/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import javax.servlet.ServletContext;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.jboss.weld.environment.jetty.JettyWeldInjector;
import org.jboss.weld.environment.servlet.logging.JettyLogger;

public class WeldDecorator
implements Decorator {
    private ServletContext servletContext;
    private JettyWeldInjector injector;

    protected WeldDecorator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static void process(ServletContext context) {
        ContextHandler.Context cc;
        ContextHandler handler;
        if (context instanceof ContextHandler.Context && (handler = (cc = (ContextHandler.Context)context).getContextHandler()) instanceof ServletContextHandler) {
            ServletContextHandler sch = (ServletContextHandler)handler;
            DecoratedObjectFactory decObjFact = sch.getObjectFactory();
            decObjFact.addDecorator((Decorator)new WeldDecorator(context));
        }
    }

    protected JettyWeldInjector getInjector() {
        if (this.injector == null) {
            JettyWeldInjector jwi = (JettyWeldInjector)this.servletContext.getAttribute("org.jboss.weld.environment.jetty.JettyWeldInjector");
            if (jwi == null) {
                throw JettyLogger.LOG.noSuchJettyInjectorFound();
            }
            this.injector = jwi;
        }
        return this.injector;
    }

    public <T> T decorate(T o) {
        this.getInjector().inject(o);
        return o;
    }

    public void destroy(Object o) {
        this.getInjector().destroy(o);
    }
}

