/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.DynamicLookupInjectionPoint;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeBeanResolver;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR", "SE_BAD_FIELD"}, justification="Uses SerializationProxy")
public class InstanceImpl<T>
extends AbstractFacade<T, Instance<T>>
implements WeldInstance<T>,
Serializable {
    private static final long serialVersionUID = -376721889693284887L;
    private final transient Set<Bean<?>> allBeans;
    private final transient Bean<?> bean;
    private final transient CurrentInjectionPoint currentInjectionPoint;
    private final transient InjectionPoint ip;
    private final transient EjbSupport ejbSupport;

    public static <I> Instance<I> of(InjectionPoint injectionPoint, CreationalContext<I> creationalContext, BeanManagerImpl beanManager) {
        return new InstanceImpl<I>(injectionPoint, creationalContext, beanManager);
    }

    private InstanceImpl(InjectionPoint injectionPoint, CreationalContext<? super T> creationalContext, BeanManagerImpl beanManager) {
        super(injectionPoint, creationalContext, beanManager);
        Resolvable resolvable = new ResolvableBuilder(this.getType(), this.getBeanManager()).addQualifiers(this.getQualifiers()).setDeclaringBean(this.getInjectionPoint().getBean()).create();
        TypeSafeBeanResolver beanResolver = this.getBeanManager().getBeanResolver();
        this.allBeans = beanResolver.resolve((Set)beanResolver.resolve(resolvable, Reflections.isCacheable(this.getQualifiers())));
        this.bean = this.allBeans.size() == 1 ? this.allBeans.iterator().next() : null;
        this.currentInjectionPoint = beanManager.getServices().getRequired(CurrentInjectionPoint.class);
        this.ip = new DynamicLookupInjectionPoint(this.getInjectionPoint(), this.getType(), this.getQualifiers());
        this.ejbSupport = beanManager.getServices().get(EjbSupport.class);
    }

    @Override
    public T get() {
        if (this.bean != null) {
            return this.getBeanInstance(this.bean);
        }
        if (this.isUnsatisfied()) {
            throw BeanManagerLogger.LOG.injectionPointHasUnsatisfiedDependencies(Formats.formatAnnotations(this.ip.getQualifiers()), Formats.formatInjectionPointType(this.ip.getType()), InjectionPoints.getUnsatisfiedDependenciesAdditionalInfo(this.ip, this.getBeanManager()));
        }
        throw BeanManagerLogger.LOG.injectionPointHasAmbiguousDependencies(Formats.formatAnnotations(this.ip.getQualifiers()), Formats.formatInjectionPointType(this.ip.getType()), WeldCollections.toMultiRowString(this.allBeans));
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Instance<" + Formats.formatType(this.getType()) + ">";
    }

    @Override
    public Iterator<T> iterator() {
        return new InstanceImplIterator(this.allBeans);
    }

    @Override
    public boolean isAmbiguous() {
        return this.allBeans.size() > 1;
    }

    @Override
    public boolean isUnsatisfied() {
        return this.allBeans.isEmpty();
    }

    @Override
    public WeldInstance<T> select(Annotation ... qualifiers) {
        return this.selectInstance(this.getType(), qualifiers);
    }

    @Override
    public <U extends T> WeldInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype, qualifiers);
    }

    @Override
    public <U extends T> WeldInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype.getType(), qualifiers);
    }

    private <U extends T> WeldInstance<U> selectInstance(Type subtype, Annotation[] newQualifiers) {
        FacadeInjectionPoint modifiedInjectionPoint = new FacadeInjectionPoint(this.getBeanManager(), this.getInjectionPoint(), (Type)((Object)Instance.class), subtype, this.getQualifiers(), newQualifiers);
        return new InstanceImpl(modifiedInjectionPoint, this.getCreationalContext(), this.getBeanManager());
    }

    @Override
    public void destroy(T instance) {
        ProxyObject proxy;
        Preconditions.checkNotNull(instance);
        if (instance instanceof ProxyObject && (proxy = (ProxyObject)instance).getHandler() instanceof ProxyMethodHandler) {
            ProxyMethodHandler handler = (ProxyMethodHandler)proxy.getHandler();
            Bean<?> bean = handler.getBean();
            if (this.isSessionBeanProxy(instance) && Dependent.class.equals(bean.getScope())) {
                this.destroyDependentInstance(instance);
                return;
            }
            Context context = this.getBeanManager().getContext(bean.getScope());
            if (context instanceof AlterableContext) {
                AlterableContext alterableContext = (AlterableContext)context;
                alterableContext.destroy(bean);
                return;
            }
            throw BeanLogger.LOG.destroyUnsupported(context);
        }
        this.destroyDependentInstance(instance);
    }

    @Override
    public WeldInstance.Handler<T> getHandler() {
        return new HandlerImpl<T>(this.get(), this, this.bean);
    }

    @Override
    public boolean isResolvable() {
        return !this.isUnsatisfied() && !this.isAmbiguous();
    }

    @Override
    public Iterable<WeldInstance.Handler<T>> handlers() {
        return new Iterable<WeldInstance.Handler<T>>(){

            @Override
            public Iterator<WeldInstance.Handler<T>> iterator() {
                return new HandlerIterator(InstanceImpl.this.allBeans);
            }
        };
    }

    private boolean isSessionBeanProxy(T instance) {
        return this.ejbSupport != null ? this.ejbSupport.isSessionBeanProxy(instance) : false;
    }

    private void destroyDependentInstance(T instance) {
        CreationalContext ctx = this.getCreationalContext();
        if (ctx instanceof WeldCreationalContext) {
            WeldCreationalContext weldCtx = (WeldCreationalContext)Reflections.cast(ctx);
            weldCtx.destroyDependentInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getBeanInstance(Bean<?> bean) {
        ThreadLocalStack.ThreadLocalStackReference<InjectionPoint> stack = this.currentInjectionPoint.push(this.ip);
        try {
            Object t = Reflections.cast(this.getBeanManager().getReference(bean, this.getType(), this.getCreationalContext(), false));
            return t;
        }
        finally {
            stack.pop();
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.serializationProxyRequired();
    }

    private static class HandlerImpl<T>
    implements WeldInstance.Handler<T> {
        private final T value;
        private final Bean<?> bean;
        private final WeakReference<WeldInstance<T>> weldInstance;
        private boolean destroyed;

        HandlerImpl(T value, WeldInstance<T> instance, Bean<?> bean) {
            this.value = value;
            this.bean = bean;
            this.weldInstance = new WeakReference<WeldInstance<WeldInstance<T>>>(instance);
            this.destroyed = false;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Bean<?> getBean() {
            return this.bean;
        }

        @Override
        public void destroy() {
            WeldInstance instance = (WeldInstance)this.weldInstance.get();
            if (instance == null || this.destroyed) {
                return;
            }
            instance.destroy(this.value);
            this.destroyed = true;
        }

        @Override
        public void close() {
            this.destroy();
        }
    }

    class HandlerIterator
    extends BeanIterator<WeldInstance.Handler<T>> {
        private HandlerIterator(Set<Bean<?>> beans) {
            super(beans);
        }

        @Override
        public WeldInstance.Handler<T> next() {
            Bean bean = (Bean)this.delegate.next();
            return new HandlerImpl<Object>(InstanceImpl.this.getBeanInstance(bean), InstanceImpl.this, bean);
        }
    }

    class InstanceImplIterator
    extends BeanIterator<T> {
        private InstanceImplIterator(Set<Bean<?>> beans) {
            super(beans);
        }

        @Override
        public T next() {
            return InstanceImpl.this.getBeanInstance((Bean)this.delegate.next());
        }
    }

    abstract class BeanIterator<T>
    implements Iterator<T> {
        protected final Iterator<Bean<?>> delegate;

        private BeanIterator(Set<Bean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            throw BeanLogger.LOG.instanceIteratorRemoveUnsupported();
        }
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Instance<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(InstanceImpl<T> instance) {
            super(instance);
        }

        private Object readResolve() throws ObjectStreamException {
            return InstanceImpl.of(this.getInjectionPoint(), this.getCreationalContext(), this.getBeanManager());
        }
    }
}

