/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.EventContext;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import org.jboss.weld.bootstrap.events.configurator.Configurator;
import org.jboss.weld.bootstrap.events.configurator.Configurators;
import org.jboss.weld.event.SyntheticObserverMethod;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.resolution.CovariantTypes;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;

public class ObserverMethodConfiguratorImpl<T>
implements ObserverMethodConfigurator<T>,
Configurator<ObserverMethod<T>> {
    private Class<?> beanClass;
    private Type observedType;
    private final Set<Annotation> observedQualifiers;
    private Reception reception = Reception.ALWAYS;
    private TransactionPhase txPhase = TransactionPhase.IN_PROGRESS;
    private int priority = 2500;
    private boolean isAsync;
    private ObserverMethodConfigurator.EventConsumer<T> notifyCallback;
    private final Extension extension;

    public ObserverMethodConfiguratorImpl(Extension extension) {
        this.observedQualifiers = new HashSet<Annotation>();
        this.extension = extension;
        this.beanClass = extension.getClass();
    }

    public ObserverMethodConfiguratorImpl(ObserverMethod<T> observerMethod, Extension extension) {
        this(extension);
        this.read(observerMethod);
        this.notifyWith(e -> observerMethod.notify(e));
    }

    @Override
    public ObserverMethodConfigurator<T> read(Method method) {
        Preconditions.checkArgumentNotNull(method);
        Set<Parameter> eventParameters = Configurators.getAnnotatedParameters(method, Observes.class, ObservesAsync.class);
        this.checkEventParams(eventParameters, method);
        Parameter eventParameter = eventParameters.iterator().next();
        Observes observesAnnotation = eventParameter.getAnnotation(Observes.class);
        if (observesAnnotation != null) {
            this.reception(observesAnnotation.notifyObserver());
            this.transactionPhase(observesAnnotation.during());
        } else {
            this.reception(eventParameter.getAnnotation(ObservesAsync.class).notifyObserver());
        }
        Priority priority = method.getAnnotation(Priority.class);
        if (priority != null) {
            this.priority(priority.value());
        }
        this.beanClass(eventParameter.getDeclaringExecutable().getDeclaringClass());
        this.observedType(eventParameter.getType());
        this.qualifiers(Configurators.getQualifiers(eventParameter));
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> read(AnnotatedMethod<?> method) {
        Preconditions.checkArgumentNotNull(method);
        Set eventParameters = method.getParameters().stream().filter(p -> p.isAnnotationPresent(Observes.class) || p.isAnnotationPresent(ObservesAsync.class)).collect(Collectors.toSet());
        this.checkEventParams(eventParameters, method.getJavaMember());
        AnnotatedParameter eventParameter = (AnnotatedParameter)eventParameters.iterator().next();
        Observes observesAnnotation = eventParameter.getAnnotation(Observes.class);
        if (observesAnnotation != null) {
            this.reception(observesAnnotation.notifyObserver());
            this.transactionPhase(observesAnnotation.during());
        } else {
            this.reception(eventParameter.getAnnotation(ObservesAsync.class).notifyObserver());
        }
        Priority priority = method.getAnnotation(Priority.class);
        if (priority != null) {
            this.priority(priority.value());
        }
        this.beanClass(eventParameter.getDeclaringCallable().getDeclaringType().getJavaClass());
        this.observedType(eventParameter.getBaseType());
        this.qualifiers(Configurators.getQualifiers(eventParameter));
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> read(ObserverMethod<T> observerMethod) {
        Preconditions.checkArgumentNotNull(observerMethod);
        this.beanClass(observerMethod.getBeanClass());
        this.observedType(observerMethod.getObservedType());
        this.qualifiers(observerMethod.getObservedQualifiers());
        this.reception(observerMethod.getReception());
        this.transactionPhase(observerMethod.getTransactionPhase());
        this.priority(observerMethod.getPriority());
        this.async(observerMethod.isAsync());
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> observedType(Type type) {
        Preconditions.checkArgumentNotNull(type);
        if (this.observedType != null && !CovariantTypes.isAssignableFrom(this.observedType, type)) {
            EventLogger.LOG.originalObservedTypeIsNotAssignableFrom(this.observedType, type, this.extension);
        }
        this.observedType = type;
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> addQualifier(Annotation qualifier) {
        Preconditions.checkArgumentNotNull(qualifier);
        this.observedQualifiers.add(qualifier);
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        Collections.addAll(this.observedQualifiers, qualifiers);
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        this.observedQualifiers.addAll(qualifiers);
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.observedQualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.observedQualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> reception(Reception reception) {
        Preconditions.checkArgumentNotNull((Object)reception);
        this.reception = reception;
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> transactionPhase(TransactionPhase transactionPhase) {
        Preconditions.checkArgumentNotNull((Object)transactionPhase);
        this.txPhase = transactionPhase;
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> priority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> notifyWith(ObserverMethodConfigurator.EventConsumer<T> callback) {
        Preconditions.checkArgumentNotNull(callback);
        this.notifyCallback = callback;
        return this;
    }

    @Override
    public ObserverMethodConfigurator<T> async(boolean async) {
        this.isAsync = async;
        return this;
    }

    @Override
    public ObserverMethod<T> complete() {
        return new ImmutableObserverMethod(this);
    }

    private <P> void checkEventParams(Set<P> eventParams, Method method) {
        if (eventParams.size() != 1) {
            EventLogger.LOG.noneOrMultipleEventParametersDeclared(method, Formats.formatAsStackTraceElement(method));
        }
    }

    static class ImmutableObserverMethod<T>
    implements SyntheticObserverMethod<T> {
        private final Class<?> beanClass;
        private final Type observedType;
        private final Set<Annotation> observedQualifiers;
        private final Reception reception;
        private final TransactionPhase txPhase;
        private final int priority;
        private final boolean isAsync;
        private final ObserverMethodConfigurator.EventConsumer<T> notifyCallback;

        ImmutableObserverMethod(ObserverMethodConfiguratorImpl<T> configurator) {
            if (((ObserverMethodConfiguratorImpl)configurator).notifyCallback == null) {
                throw EventLogger.LOG.notifyMethodNotImplemented(configurator);
            }
            this.beanClass = ((ObserverMethodConfiguratorImpl)configurator).beanClass;
            this.observedType = ((ObserverMethodConfiguratorImpl)configurator).observedType;
            this.observedQualifiers = ImmutableSet.copyOf(((ObserverMethodConfiguratorImpl)configurator).observedQualifiers);
            this.reception = ((ObserverMethodConfiguratorImpl)configurator).reception;
            this.txPhase = ((ObserverMethodConfiguratorImpl)configurator).txPhase;
            this.priority = ((ObserverMethodConfiguratorImpl)configurator).priority;
            this.isAsync = ((ObserverMethodConfiguratorImpl)configurator).isAsync;
            this.notifyCallback = ((ObserverMethodConfiguratorImpl)configurator).notifyCallback;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        @Override
        public Type getObservedType() {
            return this.observedType;
        }

        @Override
        public Set<Annotation> getObservedQualifiers() {
            return this.observedQualifiers;
        }

        @Override
        public Reception getReception() {
            return this.reception;
        }

        @Override
        public TransactionPhase getTransactionPhase() {
            return this.txPhase;
        }

        @Override
        public void notify(EventContext<T> eventContext) {
            try {
                this.notifyCallback.accept(eventContext);
            }
            catch (Exception e) {
                throw new ObserverException(e);
            }
        }

        @Override
        public boolean isAsync() {
            return this.isAsync;
        }

        @Override
        public boolean isEventMetadataRequired() {
            return true;
        }
    }
}

