/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.provider;

import java.lang.reflect.Method;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.extensions.beanManager.BeanManagerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldServletBeanManagerProvider
implements BeanManagerProvider,
Extension {
    private static String CONTAINER_CLASS_NAME = "org.jboss.weld.Container";
    private static String CONTAINER_INSTANCE_METHOD = "instance";
    private static String CONTAINER_AVAILABLE_METHOD = "available";
    private static String CONTAINER_BEAN_DEPLOYMENT_METHOD = "beanDeploymentArchives";
    private static String BEAN_DEPLOYMENT_ARCHIVE_ID = "flat";
    private static String ERROR_GETTING_BEAN_DEPLOYMENT_ARCHIVES = "Could not get BeanDeploymentArchives from Container";
    private static String ERROR_CONTAINER_NOT_AVAILABLE = "Container has not been initialized";
    private static final Logger log = LoggerFactory.getLogger(WeldServletBeanManagerProvider.class);

    public int getPrecedence() {
        return 101;
    }

    public BeanManager getBeanManager() {
        Class containerClass = null;
        try {
            containerClass = Reflections.classForName(CONTAINER_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        try {
            if (this.isContainerAvailable(containerClass)) {
                Object container = this.getAvailableContainer(containerClass);
                Map<?, ?> beanDeploymentArchives = this.getBeanDeploymentArchives(containerClass, container);
                return this.findBeanDeploymentArchiveById(beanDeploymentArchives, BEAN_DEPLOYMENT_ARCHIVE_ID);
            }
            log.debug(ERROR_CONTAINER_NOT_AVAILABLE);
        }
        catch (Exception e) {
            log.warn(ERROR_GETTING_BEAN_DEPLOYMENT_ARCHIVES, (Throwable)e);
        }
        return null;
    }

    private boolean isContainerAvailable(Class<?> containerClass) {
        Method available = Reflections.findDeclaredMethod(containerClass, CONTAINER_AVAILABLE_METHOD, new Class[0]);
        if (available == null) {
            throw new IllegalArgumentException("Method " + CONTAINER_AVAILABLE_METHOD + " could not be found on " + containerClass);
        }
        return Reflections.invokeMethod(available, Boolean.class, null, new Object[0]);
    }

    private Object getAvailableContainer(Class<?> containerClass) {
        Method instance = Reflections.findDeclaredMethod(containerClass, CONTAINER_INSTANCE_METHOD, new Class[0]);
        if (instance == null) {
            throw new IllegalArgumentException("Method " + CONTAINER_INSTANCE_METHOD + " could not be found on " + containerClass);
        }
        return Reflections.invokeMethod(instance, Object.class, null, new Object[0]);
    }

    private Map<?, ?> getBeanDeploymentArchives(Class<?> containerClass, Object container) {
        Method deploymentManager = Reflections.findDeclaredMethod(containerClass, CONTAINER_BEAN_DEPLOYMENT_METHOD, new Class[0]);
        if (deploymentManager == null) {
            throw new IllegalArgumentException("Method " + CONTAINER_BEAN_DEPLOYMENT_METHOD + " could not be found on " + containerClass);
        }
        return Reflections.invokeMethod(deploymentManager, Map.class, container, new Object[0]);
    }

    private BeanManager findBeanDeploymentArchiveById(Map<?, ?> beanDeploymentArchives, String id) {
        for (Map.Entry<?, ?> beanDeploymentEntry : beanDeploymentArchives.entrySet()) {
            Object beanManagerDeployment = beanDeploymentEntry.getKey();
            if (!(beanManagerDeployment instanceof BeanDeploymentArchive)) {
                throw new IllegalStateException("beanDeploymentArchive is not a BeanDeploymentArchive");
            }
            String beanArchiveId = ((BeanDeploymentArchive)BeanDeploymentArchive.class.cast(beanManagerDeployment)).getId();
            if (!id.equals(beanArchiveId)) continue;
            return (BeanManager)BeanManager.class.cast(beanDeploymentEntry.getValue());
        }
        return null;
    }
}

