/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.context.FacesContext;
import org.jboss.weld.Container;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.jsf.FacesUrlTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationAwareViewHandler
extends ViewHandlerWrapper {
    private final ViewHandler delegate;
    private final ConversationContext conversationContext;
    private final ThreadLocal<Source> source;

    public ConversationAwareViewHandler(ViewHandler delegate) {
        this.delegate = delegate;
        Container container = Container.instance();
        this.conversationContext = (ConversationContext)container.deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
        this.source = new ThreadLocal();
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        String actionUrl = super.getActionURL(facesContext, viewId);
        ManagedConversation conversation = this.conversationContext.getCurrentConversation();
        if (!this.getSource().equals((Object)Source.BOOKMARKABLE) && !conversation.isTransient()) {
            return new FacesUrlTransformer(actionUrl, facesContext).appendConversationIdIfNecessary(this.conversationContext.getParameterName(), conversation.getId()).getUrl();
        }
        return actionUrl;
    }

    private Source getSource() {
        if (this.source.get() == null) {
            return Source.ACTION;
        }
        return this.source.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        try {
            this.source.set(Source.BOOKMARKABLE);
            String string = super.getBookmarkableURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            this.source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        try {
            this.source.set(Source.REDIRECT);
            String string = super.getRedirectURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            this.source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceURL(FacesContext context, String path) {
        try {
            this.source.set(Source.RESOURCE);
            String string = super.getResourceURL(context, path);
            return string;
        }
        finally {
            this.source.remove();
        }
    }

    public ViewHandler getWrapped() {
        return this.delegate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Source {
        ACTION,
        BOOKMARKABLE,
        REDIRECT,
        RESOURCE;

    }
}

