/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import javassist.util.proxy.ProxyFactory;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.environment.jetty.JettyWeldInjector;
import org.jboss.weld.environment.servlet.deployment.ServletDeployment;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.jboss.weld.environment.servlet.deployment.VFSURLScanner;
import org.jboss.weld.environment.servlet.services.ServletResourceInjectionServices;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.tomcat.WeldForwardingAnnotationProcessor;
import org.jboss.weld.environment.tomcat7.WeldForwardingInstanceManager;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener
extends ForwardingServletListener {
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    private static final String WELD_LISTENER_CLASS_NAME = "org.jboss.weld.servlet.WeldListener";
    private static final String EXPRESSION_FACTORY_NAME = "org.jboss.weld.el.ExpressionFactory";
    private static final String JETTY_REQUIRED_CLASS_NAME = "org.mortbay.jetty.servlet.ServletHandler";
    public static final String INJECTOR_ATTRIBUTE_NAME = "org.jboss.weld.environment.jetty.JettyWeldInjector";
    public static final String BEAN_MANAGER_ATTRIBUTE_NAME = Listener.class.getPackage().getName() + "." + BeanManager.class.getName();
    private final transient Bootstrap bootstrap;
    private final transient ServletListener weldListener;

    public Listener() {
        try {
            this.bootstrap = (Bootstrap)Reflections.newInstance(BOOTSTRAP_IMPL_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", e);
        }
        try {
            this.weldListener = (ServletListener)Reflections.newInstance(WELD_LISTENER_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error loading Weld listener, check that Weld is on the classpath", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.bootstrap.shutdown();
        try {
            Reflections.classForName("org.apache.AnnotationProcessor");
            WeldForwardingAnnotationProcessor.restoreAnnotationProcessor(sce);
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Reflections.classForName(JETTY_REQUIRED_CLASS_NAME);
            sce.getServletContext().removeAttribute(INJECTOR_ATTRIBUTE_NAME);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        super.contextDestroyed(sce);
    }

    protected ServletDeployment createServletDeployment(ServletContext context, Bootstrap bootstrap) {
        return new ServletDeployment(context, bootstrap);
    }

    protected URLScanner createUrlScanner(ClassLoader classLoader, ServletContext context) {
        try {
            classLoader.loadClass("org.jboss.virtual.VFS");
            return new VFSURLScanner(classLoader);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        boolean tomcat7;
        ServletContext context;
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            public ClassLoader get(ProxyFactory pf) {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        ClassLoader classLoader = Reflections.getClassLoader();
        URLScanner scanner = this.createUrlScanner(classLoader, context = sce.getServletContext());
        if (scanner != null) {
            context.setAttribute(URLScanner.class.getName(), (Object)scanner);
        }
        ServletDeployment deployment = this.createServletDeployment(context, this.bootstrap);
        try {
            deployment.getWebAppBeanDeploymentArchive().getServices().add(ResourceInjectionServices.class, new ServletResourceInjectionServices(){});
        }
        catch (NoClassDefFoundError e) {
            log.warn("@Resource injection not available in simple beans");
        }
        this.bootstrap.startContainer(Environments.SERVLET, deployment).startInitialization();
        WeldManager manager = this.bootstrap.getManager(deployment.getWebAppBeanDeploymentArchive());
        boolean tomcat = true;
        try {
            Reflections.classForName("org.apache.AnnotationProcessor");
        }
        catch (IllegalArgumentException e) {
            tomcat = false;
        }
        if (tomcat) {
            try {
                WeldForwardingAnnotationProcessor.replaceAnnotationProcessor(sce, manager);
                log.info("Tomcat 6 detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported");
            }
            catch (Exception e) {
                log.error("Unable to replace Tomcat AnnotationProcessor. CDI injection will not be available in Servlets, Filters, or Listeners", (Throwable)e);
            }
        }
        try {
            Reflections.classForName("org.apache.tomcat.InstanceManager");
            tomcat7 = true;
        }
        catch (IllegalArgumentException e) {
            tomcat7 = false;
        }
        boolean jetty = true;
        try {
            Reflections.classForName(JETTY_REQUIRED_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            jetty = false;
        }
        if (jetty) {
            try {
                Class clazz = Reflections.classForName(JettyWeldInjector.class.getName());
                Object injector = clazz.getConstructor(WeldManager.class).newInstance(manager);
                context.setAttribute(INJECTOR_ATTRIBUTE_NAME, injector);
                log.info("Jetty detected, JSR-299 injection will be available in Servlets and Filters. Injection into Listeners is not supported.");
            }
            catch (Exception e) {
                log.error("Unable to create JettyWeldInjector. CDI injection will not be available in Servlets, Filters or Listeners", (Throwable)e);
            }
        }
        if (tomcat7) {
            try {
                WeldForwardingInstanceManager.replacInstanceManager(sce, manager);
                log.info("Tomcat 7 detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported");
            }
            catch (Exception e) {
                log.error("Unable to replace Tomcat 7 AnnotationProcessor. CDI injection will not be available in Servlets, Filters, or Listeners", (Throwable)e);
            }
        }
        if (!(tomcat || jetty || tomcat7)) {
            log.info("No supported servlet container detected, CDI injection will NOT be available in Servlets, Filtersor or Listeners");
        }
        context.setAttribute(BEAN_MANAGER_ATTRIBUTE_NAME, (Object)manager);
        if (JspFactory.getDefaultFactory() != null) {
            JspApplicationContext jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            jspApplicationContext.addELContextListener((ELContextListener)Reflections.newInstance("org.jboss.weld.el.WeldELContextListener"));
            context.setAttribute(EXPRESSION_FACTORY_NAME, (Object)manager.wrapExpressionFactory(jspApplicationContext.getExpressionFactory()));
        }
        this.bootstrap.deployBeans().validateBeans().endInitialization();
        super.contextInitialized(sce);
    }

    protected ServletListener delegate() {
        return this.weldListener;
    }
}

