/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.util.reflection.Reflections;

public class CreationalContextImpl<T>
implements CreationalContext<T>,
WeldCreationalContext<T>,
Serializable {
    private static final long serialVersionUID = 7375854583908262422L;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Not needed after initial creation")
    private final transient Map<Contextual<?>, Object> incompleteInstances;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Not needed after initial creation")
    private final transient Contextual<T> contextual;
    private final List<ContextualInstance<?>> dependentInstances;
    private final List<ContextualInstance<?>> parentDependentInstances;

    public CreationalContextImpl(Contextual<T> contextual) {
        this(contextual, new HashMap(), Collections.synchronizedList(new ArrayList()));
    }

    private CreationalContextImpl(Contextual<T> contextual, Map<Contextual<?>, Object> incompleteInstances, List<ContextualInstance<?>> parentDependentInstancesStore) {
        this.incompleteInstances = incompleteInstances;
        this.contextual = contextual;
        this.dependentInstances = Collections.synchronizedList(new ArrayList());
        this.parentDependentInstances = parentDependentInstancesStore;
    }

    @Override
    public void push(T incompleteInstance) {
        this.incompleteInstances.put(this.contextual, incompleteInstance);
    }

    @Override
    public <S> WeldCreationalContext<S> getCreationalContext(Contextual<S> contextual) {
        return new CreationalContextImpl<S>(contextual, this.incompleteInstances == null ? new HashMap() : new HashMap(this.incompleteInstances), this.dependentInstances);
    }

    @Override
    public <S> S getIncompleteInstance(Contextual<S> bean) {
        return this.incompleteInstances == null ? null : (S)Reflections.cast(this.incompleteInstances.get(bean));
    }

    @Override
    public boolean containsIncompleteInstance(Contextual<?> bean) {
        return this.incompleteInstances != null && this.incompleteInstances.containsKey(bean);
    }

    @Override
    public void addDependentInstance(ContextualInstance<?> contextualInstance) {
        this.parentDependentInstances.add(contextualInstance);
    }

    @Override
    public void release() {
        this.release(null, null);
    }

    public void release(Contextual<T> contextual, T instance) {
        for (ContextualInstance<?> dependentInstance : this.dependentInstances) {
            if (contextual != null && dependentInstance.getContextual().equals(contextual)) continue;
            CreationalContextImpl.destroy(dependentInstance);
        }
    }

    private static <T> void destroy(ContextualInstance<T> beanInstance) {
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
    }

    @Override
    public List<ContextualInstance<?>> getDependentInstances() {
        return Collections.unmodifiableList(this.dependentInstances);
    }

    protected Object writeReplace() throws ObjectStreamException {
        Iterator<ContextualInstance<?>> iterator = this.dependentInstances.iterator();
        while (iterator.hasNext()) {
            ContextualInstance<?> instance = iterator.next();
            if (instance.getInstance() instanceof Serializable) continue;
            CreationalContextImpl.destroy(instance);
            iterator.remove();
        }
        return this;
    }
}

