/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and/or its affiliates, and individual
 * contributors by the @authors tag. See the copyright.txt in the
 * distribution for a full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.interceptor.proxy;

import java.lang.reflect.Method;

import javax.interceptor.InvocationContext;

import org.jboss.interceptor.spi.context.InterceptionChain;
import org.jboss.interceptor.spi.context.InvocationContextFactory;

/**
 * @author Marius Bogoevici
 */
public class DefaultInvocationContextFactory implements InvocationContextFactory
{
   public InvocationContext newInvocationContext(InterceptionChain chain, Object o, Method method, Object[] args)
   {
      return new InterceptorInvocationContext(chain, o, method, args);
   }

   public InvocationContext newInvocationContext(InterceptionChain chain, Object o, Method method, Object timer)
   {
      return new InterceptorInvocationContext(chain, o, method, timer);
   }
}
