/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.tomcat;

import org.jboss.weld.environment.AbstractContainer;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.tomcat.WeldForwardingAnnotationProcessor;

public class Tomcat6Container
extends AbstractContainer {
    public static Container INSTANCE = new Tomcat6Container();

    @Override
    protected String classToCheck() {
        return "org.apache.catalina.core.ApplicationContextFacade";
    }

    @Override
    public void initialize(ContainerContext context) {
        try {
            WeldForwardingAnnotationProcessor.replaceAnnotationProcessor(context.getEvent(), context.getManager());
            this.log.info("Tomcat 6 detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported");
        }
        catch (Exception e) {
            this.log.error("Unable to replace Tomcat AnnotationProcessor. CDI injection will not be available in Servlets, Filters, or Listeners", (Throwable)e);
        }
    }

    @Override
    public void destroy(ContainerContext context) {
        WeldForwardingAnnotationProcessor.restoreAnnotationProcessor(context.getEvent());
    }
}

