/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbDescriptor;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;

public class InternalEjbDescriptor<T>
extends ForwardingEjbDescriptor<T>
implements EjbDescriptor<T> {
    private final Class<?> objectInterface;
    private final EjbDescriptor<T> delegate;
    private final Collection<MethodSignature> removeMethodSignatures;

    public InternalEjbDescriptor(EjbDescriptor<T> ejbDescriptor) {
        this.delegate = ejbDescriptor;
        this.objectInterface = InternalEjbDescriptor.findObjectInterface(ejbDescriptor.getLocalBusinessInterfaces());
        this.removeMethodSignatures = new ArrayList<MethodSignature>();
        if (ejbDescriptor.getRemoveMethods() != null) {
            for (Method method : ejbDescriptor.getRemoveMethods()) {
                this.removeMethodSignatures.add(new MethodSignatureImpl(method));
            }
        }
    }

    @Override
    public EjbDescriptor<T> delegate() {
        return this.delegate;
    }

    public Class<?> getObjectInterface() {
        return this.objectInterface;
    }

    public Collection<MethodSignature> getRemoveMethodSignatures() {
        return this.removeMethodSignatures;
    }

    private static Class<?> findObjectInterface(Collection<BusinessInterfaceDescriptor<?>> interfaces) {
        if (interfaces != null && !interfaces.isEmpty()) {
            return interfaces.iterator().next().getInterface();
        }
        return null;
    }
}

