/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

public abstract class RIBean<T>
implements Bean<T>,
PassivationCapable {
    public static final String BEAN_ID_PREFIX = RIBean.class.getPackage().getName();
    public static final String BEAN_ID_SEPARATOR = "-";
    private final BeanManagerImpl beanManager;
    private final String id;
    private final int hashCode;
    private volatile Set<QualifierInstance> qualifiers;

    protected RIBean(String idSuffix, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.id = BEAN_ID_PREFIX + BEAN_ID_SEPARATOR + beanManager.getId() + BEAN_ID_SEPARATOR + idSuffix;
        this.hashCode = this.id.hashCode();
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public abstract Class<T> getType();

    @Override
    public Class<?> getBeanClass() {
        return this.getType();
    }

    public abstract void initialize(BeanDeployerEnvironment var1);

    public abstract void cleanupAfterBoot();

    public abstract void initializeAfterBeanDiscovery();

    public abstract boolean isSpecializing();

    public boolean isDependent() {
        return this.getScope().equals(Dependent.class);
    }

    public abstract boolean isProxyable();

    public abstract boolean isPassivationCapableBean();

    public abstract boolean isPassivationCapableDependency();

    public abstract boolean isProxyRequired();

    public abstract boolean isPrimitive();

    public abstract Set<WeldInjectionPoint<?, ?>> getWeldInjectionPoints();

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return (Set)Reflections.cast(this.getWeldInjectionPoints());
    }

    public abstract RIBean<?> getSpecializedBean();

    public boolean equals(Object obj) {
        if (obj instanceof RIBean) {
            RIBean that = (RIBean)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public Set<QualifierInstance> getQualifierInstances() {
        if (this.qualifiers == null) {
            MetaAnnotationStore store = this.beanManager.getServices().get(MetaAnnotationStore.class);
            HashSet<QualifierInstance> ret = new HashSet<QualifierInstance>();
            for (Annotation a : this.getQualifiers()) {
                ret.add(new QualifierInstance(a, store));
            }
            this.qualifiers = ret;
        }
        return this.qualifiers;
    }

    public boolean isNormalScoped() {
        return Beans.isNormalScoped(this);
    }
}

