/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.HashMultimap;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.interceptor.Interceptor;
import org.jboss.weld.Container;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.introspector.DiscoveredExternalAnnotatedType;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

public class BeanDeployer
extends AbstractBeanDeployer<BeanDeployerEnvironment> {
    private transient LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CLASS_LOADING);
    private transient XLogger xlog = LoggerFactory.loggerFactory().getXLogger(Category.CLASS_LOADING);
    private final Set<WeldClass<?>> classes = new HashSet();
    private final Set<Class<?>> vetoedClasses = new HashSet();
    private final ResourceLoader resourceLoader;
    private final ClassTransformer classTransformer;

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services) {
        super(manager, services, new BeanDeployerEnvironment(ejbDescriptors, manager));
        this.resourceLoader = manager.getServices().get(ResourceLoader.class);
        this.classTransformer = Container.instance().services().get(ClassTransformer.class);
    }

    public BeanDeployer addClass(String className) {
        WeldClass<?> weldClass;
        Class<?> clazz = this.loadClass(className);
        if (clazz != null && this.isBeanCandidate(clazz) && (weldClass = this.loadWeldClass(clazz)) != null) {
            ProcessAnnotatedTypeImpl<?> event = ProcessAnnotatedTypeImpl.fire(this.getManager(), weldClass);
            if (!event.isVeto()) {
                if (event.getAnnotatedType() instanceof WeldClass) {
                    this.classes.add((WeldClass)event.getAnnotatedType());
                } else {
                    this.classes.add(this.classTransformer.loadClass(DiscoveredExternalAnnotatedType.of(event.getAnnotatedType(), weldClass)));
                }
            } else if (weldClass.isDiscovered()) {
                this.vetoedClasses.add(weldClass.getJavaClass());
            }
        }
        return this;
    }

    private boolean isBeanCandidate(Class<?> clazz) {
        try {
            return !clazz.isAnnotation() && !clazz.isEnum() && !Reflections.isNonStaticInnerClass(clazz);
        }
        catch (LinkageError e) {
            this.logIgnoredClass(clazz.getName(), e);
            return false;
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return this.resourceLoader.classForName(className);
        }
        catch (ResourceLoadingException e) {
            this.logIgnoredClass(className, e);
            return null;
        }
    }

    private WeldClass<?> loadWeldClass(Class<?> clazz) {
        try {
            return this.classTransformer.loadClass(clazz);
        }
        catch (ResourceLoadingException e) {
            this.logIgnoredClass(clazz.getName(), e);
            return null;
        }
    }

    private void logIgnoredClass(String className, Throwable e) {
        this.log.info(BootstrapMessage.IGNORING_CLASS_DUE_TO_LOADING_ERROR, className);
        this.xlog.catching(XLogger.Level.DEBUG, e);
    }

    public BeanDeployer addClass(AnnotatedType<?> clazz) {
        this.classes.add(this.classTransformer.loadClass(clazz));
        return this;
    }

    public BeanDeployer addClasses(Iterable<String> classes) {
        for (String className : classes) {
            this.addClass(className);
        }
        return this;
    }

    public BeanDeployer createBeans() {
        HashMultimap otherWeldClasses = HashMultimap.create();
        for (WeldClass<?> weldClass : this.classes) {
            boolean managedBeanOrDecorator;
            boolean bl = managedBeanOrDecorator = !((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors().contains(weldClass.getJavaClass()) && this.isTypeManagedBeanOrDecoratorOrInterceptor(weldClass);
            if (managedBeanOrDecorator && weldClass.isAnnotationPresent(Decorator.class)) {
                this.validateDecorator(weldClass);
                this.createDecorator(weldClass);
                continue;
            }
            if (managedBeanOrDecorator && weldClass.isAnnotationPresent(Interceptor.class)) {
                this.validateInterceptor(weldClass);
                this.createInterceptor(weldClass);
                continue;
            }
            if (managedBeanOrDecorator && !weldClass.isAbstract()) {
                this.createManagedBean(weldClass);
                continue;
            }
            otherWeldClasses.put(weldClass.getJavaClass(), weldClass);
        }
        for (InternalEjbDescriptor internalEjbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            if (this.vetoedClasses.contains(internalEjbDescriptor.getBeanClass()) || !internalEjbDescriptor.isSingleton() && !internalEjbDescriptor.isStateful() && !internalEjbDescriptor.isStateless()) continue;
            if (otherWeldClasses.containsKey(internalEjbDescriptor.getBeanClass())) {
                for (WeldClass c : otherWeldClasses.get(internalEjbDescriptor.getBeanClass())) {
                    this.createSessionBean(internalEjbDescriptor, (WeldClass)Reflections.cast(c));
                }
                continue;
            }
            this.createSessionBean(internalEjbDescriptor);
        }
        for (WeldClass weldClass : ((BeanDeployerEnvironment)this.getEnvironment()).getNewManagedBeanClasses()) {
            this.createNewManagedBean(weldClass);
        }
        for (InternalEjbDescriptor internalEjbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getNewSessionBeanDescriptors()) {
            this.createNewSessionBean(internalEjbDescriptor);
        }
        return this;
    }

    public void registerCdiInterceptorsForMessageDrivenBeans() {
        EjbServices ejbServices = this.getManager().getServices().get(EjbServices.class);
        for (InternalEjbDescriptor<?> descriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            InterceptionModel<ClassMetadata<?>, ?> model;
            WeldClass<?> annotatedType;
            if (!descriptor.isMessageDriven()) continue;
            if (!this.getManager().getInterceptorModelRegistry().containsKey(descriptor.getBeanClass()) && (annotatedType = this.loadWeldClass(descriptor.getBeanClass())) != null) {
                new InterceptionModelInitializer(this.getManager(), annotatedType, descriptor.getBeanClass()).init();
            }
            if ((model = this.getManager().getInterceptorModelRegistry().get(descriptor.getBeanClass())) == null) continue;
            ejbServices.registerInterceptors(descriptor, new InterceptorBindingsAdapter(model));
        }
    }

    private void validateInterceptor(WeldClass<?> clazz) {
        if (clazz.isAnnotationPresent(Decorator.class)) {
            throw new DeploymentException(BootstrapMessage.BEAN_IS_BOTH_INTERCEPTOR_AND_DECORATOR, clazz.getName());
        }
    }

    private void validateDecorator(WeldClass<?> clazz) {
        if (clazz.isAnnotationPresent(Interceptor.class)) {
            throw new DeploymentException(BootstrapMessage.BEAN_IS_BOTH_INTERCEPTOR_AND_DECORATOR, clazz.getName());
        }
    }
}

