/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.io.Serializable;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.ContextualStore;

public interface WeldInjectionPoint<T, S>
extends InjectionPoint,
WeldAnnotated<T, S> {
    public WeldClass<?> getDeclaringType();

    public void inject(Object var1, Object var2);

    public static abstract class WeldInjectionPointSerializationProxy<T, S>
    implements Serializable {
        private static final long serialVersionUID = -5488095196637387378L;
        private final String declaringBeanId;
        private final Class<?> declaringClass;
        private final WeldManager beanManager;

        public WeldInjectionPointSerializationProxy(WeldInjectionPoint<T, S> injectionPoint, WeldManager beanManager) {
            this.beanManager = beanManager;
            this.declaringBeanId = injectionPoint.getBean() == null ? null : this.getService(ContextualStore.class).putIfAbsent(injectionPoint.getBean());
            this.declaringClass = injectionPoint.getDeclaringType().getJavaClass();
        }

        protected Bean<T> getDeclaringBean() {
            return this.declaringBeanId == null ? null : (Bean)this.getService(ContextualStore.class).getContextual(this.declaringBeanId);
        }

        protected WeldClass<?> getDeclaringWeldClass() {
            return this.getService(ClassTransformer.class).loadClass(this.declaringClass);
        }

        protected String getDeclaringBeanId() {
            return this.declaringBeanId;
        }

        protected WeldManager getBeanManager() {
            return this.beanManager;
        }

        protected <E extends Service> E getService(Class<E> serviceClass) {
            return this.beanManager.getServices().get(serviceClass);
        }
    }
}

