/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.attributes;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMember;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.literal.NamedLiteral;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MergedStereotypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanAttributesFactory {
    public static <T> BeanAttributes<T> forManagedBean(WeldClass<T> annotated, BeanManagerImpl manager) {
        return BeanAttributesFactory.forSessionBean(annotated, null, manager);
    }

    public static <T> BeanAttributes<T> forSessionBean(WeldClass<T> annotated, InternalEjbDescriptor<?> descriptor, BeanManagerImpl manager) {
        return new BeanAttributesBuilder(annotated, false, (InternalEjbDescriptor)Reflections.cast(descriptor), manager).build();
    }

    public static <T, X, S extends Member> BeanAttributes<T> forProducerBean(WeldMember<T, ? super X, S> annotated, BeanAttributes<X> declaringBeanAttributes, BeanManagerImpl manager) {
        return BeanAttributesFactory.forProducerBean(annotated, declaringBeanAttributes.isAlternative(), manager);
    }

    public static <T, X, S extends Member> BeanAttributes<T> forProducerBean(WeldMember<T, ?, S> annotated, boolean declaringBeanIsAlternative, BeanManagerImpl manager) {
        return new BeanAttributesBuilder(annotated, declaringBeanIsAlternative, null, manager).build();
    }

    public static <T, X> BeanAttributes<T> forDisposerMethod(WeldMethod<T, ? super X> annotated, boolean declaringBeanIsAlternative, BeanManagerImpl manager) {
        BeanAttributesBuilder<T> builder = new BeanAttributesBuilder<T>();
        WeldParameter disposerParameter = null;
        if (annotated.getWeldParameters(Disposes.class).isEmpty()) {
            throw new IllegalArgumentException("Not a disposer method");
        }
        disposerParameter = annotated.getWeldParameters().get(0);
        ((BeanAttributesBuilder)builder).nullable = false;
        builder.initStereotypes(annotated, manager);
        builder.initAlternative(annotated, declaringBeanIsAlternative);
        ((BeanAttributesBuilder)builder).name = null;
        ((BeanAttributesBuilder)builder).qualifiers = disposerParameter.getMetaAnnotations(Qualifier.class);
        ((BeanAttributesBuilder)builder).scope = null;
        ((BeanAttributesBuilder)builder).types = disposerParameter.getTypeClosure();
        return builder.build();
    }

    public static <T> BeanAttributes<T> forNewBean(boolean nullable, Set<Type> types) {
        return new ImmutableBeanAttributes(nullable, Collections.<Class<Annotation>>emptySet(), false, null, Collections.<Annotation>emptySet(), types, Dependent.class);
    }

    public static <T> BeanAttributes<T> forNewManagedBean(WeldClass<T> weldClass) {
        return BeanAttributesFactory.forNewBean(Beans.isNullable(weldClass), Beans.getTypes(weldClass));
    }

    public static <T> BeanAttributes<T> forNewSessionBean(BeanAttributes<T> originalAttributes) {
        return BeanAttributesFactory.forNewBean(originalAttributes.isNullable(), originalAttributes.getTypes());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanAttributesBuilder<T> {
        private boolean nullable;
        private MergedStereotypes<T, ?> mergedStereotypes;
        private boolean alternative;
        private String name;
        private Set<Annotation> qualifiers;
        private Set<Type> types;
        private Class<? extends Annotation> scope;

        private BeanAttributesBuilder() {
        }

        private BeanAttributesBuilder(WeldAnnotated<T, ?> annotated, boolean declaringBeanIsAlternative, InternalEjbDescriptor<T> descriptor, BeanManagerImpl manager) {
            this.initNullable(annotated);
            this.initStereotypes(annotated, manager);
            this.initAlternative(annotated, declaringBeanIsAlternative);
            this.initName(annotated);
            this.initQualifiers(annotated);
            this.initScope(annotated);
            this.types = descriptor == null ? Beans.getTypes(annotated) : Beans.getTypes(annotated, descriptor);
        }

        protected void initNullable(WeldAnnotated<?, ?> annotated) {
            this.nullable = !annotated.isPrimitive();
        }

        protected <S> void initStereotypes(WeldAnnotated<T, S> annotated, BeanManagerImpl manager) {
            this.mergedStereotypes = MergedStereotypes.of(annotated, manager);
        }

        protected void initAlternative(WeldAnnotated<T, ?> annotated, boolean declaringBeanIsAlternative) {
            this.alternative = Beans.isAlternative(annotated, this.mergedStereotypes) || declaringBeanIsAlternative;
        }

        protected void initName(WeldAnnotated<T, ?> annotated) {
            boolean beanNameDefaulted = false;
            if (annotated.isAnnotationPresent(Named.class)) {
                String javaName = annotated.getAnnotation(Named.class).value();
                if ("".equals(javaName)) {
                    beanNameDefaulted = true;
                } else {
                    this.name = javaName;
                    return;
                }
            }
            if (beanNameDefaulted || this.mergedStereotypes != null && this.mergedStereotypes.isBeanNameDefaulted()) {
                this.name = this.getDefaultName(annotated);
            }
        }

        protected String getDefaultName(WeldAnnotated<?, ?> annotated) {
            if (annotated instanceof WeldClass) {
                return Introspector.decapitalize(((WeldClass)annotated).getSimpleName());
            }
            if (annotated instanceof WeldField) {
                return ((WeldField)annotated).getPropertyName();
            }
            if (annotated instanceof WeldMethod) {
                return ((WeldMethod)annotated).getPropertyName();
            }
            return null;
        }

        protected void initQualifiers(Set<Annotation> qualifiers) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.addAll(qualifiers);
            BeanAttributesBuilder.applyDefaultQualifiers(this.qualifiers, this.name);
        }

        protected void initQualifiers(WeldAnnotated<?, ?> annotated) {
            this.initQualifiers(annotated.getMetaAnnotations(Qualifier.class));
        }

        public static void applyDefaultQualifiers(Set<Annotation> qualifiers, String name) {
            if (qualifiers.size() == 0) {
                qualifiers.add(DefaultLiteral.INSTANCE);
            }
            if (qualifiers.size() == 1 && qualifiers.iterator().next().annotationType().equals(Named.class)) {
                qualifiers.add(DefaultLiteral.INSTANCE);
            }
            qualifiers.add(AnyLiteral.INSTANCE);
            if (name != null && qualifiers.remove(NamedLiteral.DEFAULT)) {
                qualifiers.add(new NamedLiteral(name));
            }
        }

        protected void initScope(WeldAnnotated<T, ?> annotated) {
            if (annotated instanceof WeldClass) {
                WeldClass weldClass;
                for (WeldClass clazz = weldClass = (WeldClass)annotated; clazz != null; clazz = clazz.getWeldSuperclass()) {
                    HashSet<Annotation> scopes = new HashSet<Annotation>();
                    scopes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
                    scopes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
                    this.validateScopeSet(scopes, annotated);
                    if (scopes.size() != 1) continue;
                    if (annotated.isAnnotationPresent(((Annotation)scopes.iterator().next()).annotationType())) {
                        this.scope = ((Annotation)scopes.iterator().next()).annotationType();
                    }
                    break;
                }
            } else {
                HashSet<Annotation> scopes = new HashSet<Annotation>();
                scopes.addAll(annotated.getMetaAnnotations(Scope.class));
                scopes.addAll(annotated.getMetaAnnotations(NormalScope.class));
                if (scopes.size() == 1) {
                    this.scope = ((Annotation)scopes.iterator().next()).annotationType();
                }
                this.validateScopeSet(scopes, annotated);
            }
            if (this.scope == null) {
                this.initScopeFromStereotype();
            }
            if (this.scope == null) {
                this.scope = Dependent.class;
            }
        }

        protected void validateScopeSet(Set<Annotation> scopes, WeldAnnotated<T, ?> annotated) {
            if (scopes.size() > 1) {
                throw new DefinitionException(BeanMessage.ONLY_ONE_SCOPE_ALLOWED, annotated);
            }
        }

        protected boolean initScopeFromStereotype() {
            Set<Annotation> possibleScopes = this.mergedStereotypes.getPossibleScopes();
            if (possibleScopes.size() == 1) {
                this.scope = possibleScopes.iterator().next().annotationType();
                return true;
            }
            if (possibleScopes.size() > 1) {
                throw new DefinitionException(BeanMessage.MULTIPLE_SCOPES_FOUND_FROM_STEREOTYPES, this.mergedStereotypes);
            }
            return false;
        }

        public BeanAttributes<T> build() {
            return new ImmutableBeanAttributes(this.nullable, this.mergedStereotypes.getStereotypes(), this.alternative, this.name, this.qualifiers, this.types, this.scope);
        }
    }
}

