/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.http;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.SessionScoped;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.Container;
import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.SimpleNamingScheme;
import org.jboss.weld.context.beanstore.http.EagerSessionBeanStore;
import org.jboss.weld.context.beanstore.http.LazySessionBeanStore;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionContextImpl
extends AbstractBoundContext<HttpServletRequest>
implements HttpSessionContext {
    private static final String IDENTIFIER = HttpSessionContextImpl.class.getName();
    private final NamingScheme namingScheme = new SimpleNamingScheme(HttpSessionContext.class.getName());

    public HttpSessionContextImpl() {
        super(true);
    }

    @Override
    public boolean associate(HttpServletRequest request) {
        if (request.getAttribute(IDENTIFIER) == null) {
            request.setAttribute(IDENTIFIER, (Object)IDENTIFIER);
            this.setBeanStore(new LazySessionBeanStore(request, this.namingScheme));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dissociate(HttpServletRequest request) {
        if (request.getAttribute(IDENTIFIER) != null) {
            boolean bl;
            try {
                this.setBeanStore(null);
                request.removeAttribute(IDENTIFIER);
                bl = true;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.cleanup();
                throw throwable;
            }
            this.cleanup();
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy(HttpSession session) {
        if (this.getBeanStore() == null) {
            boolean bl;
            try {
                HttpConversationContext conversationContext = this.getConversationContext();
                this.setBeanStore(new EagerSessionBeanStore(this.namingScheme, session));
                this.activate();
                this.invalidate();
                conversationContext.destroy(session);
                this.deactivate();
                this.setBeanStore(null);
                bl = true;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.cleanup();
                throw throwable;
            }
            this.cleanup();
            return bl;
        }
        this.invalidate();
        this.getConversationContext().destroy(session);
        return false;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    protected HttpConversationContext getConversationContext() {
        return (HttpConversationContext)Container.instance().deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
    }

    protected Conversation getConversation() {
        return (Conversation)Container.instance().deploymentManager().instance().select(Conversation.class, new Annotation[0]).get();
    }
}

