/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.util.bean.SerializableForwardingBean;
import org.jboss.weld.util.bean.SerializableForwardingInjectionPoint;
import org.jboss.weld.util.reflection.Reflections;

public class CreationalContextImpl<T>
implements CreationalContext<T>,
WeldCreationalContext<T>,
Serializable {
    private static final long serialVersionUID = 7375854583908262422L;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Not needed after initial creation")
    private transient Map<Contextual<?>, Object> incompleteInstances;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Not needed after initial creation")
    private final transient Contextual<T> contextual;
    private final List<ContextualInstance<?>> dependentInstances;
    private final List<ContextualInstance<?>> parentDependentInstances;
    private final WeldCreationalContext<?> parentCreationalContext;
    private List<ResourceReference<?>> resourceReferences;
    private SerializableForwardingBean<T> persistentContextual;
    private SerializableForwardingInjectionPoint persistentInjectionPoint;

    public CreationalContextImpl(Contextual<T> contextual) {
        this(contextual, null, Collections.synchronizedList(new ArrayList()), null);
    }

    private CreationalContextImpl(Contextual<T> contextual, Map<Contextual<?>, Object> incompleteInstances, List<ContextualInstance<?>> parentDependentInstancesStore, WeldCreationalContext<?> parentCreationalContext) {
        this.incompleteInstances = incompleteInstances;
        this.contextual = contextual;
        this.dependentInstances = Collections.synchronizedList(new ArrayList());
        this.parentDependentInstances = parentDependentInstancesStore;
        this.parentCreationalContext = parentCreationalContext;
    }

    @Override
    public void push(T incompleteInstance) {
        if (this.incompleteInstances == null) {
            this.incompleteInstances = new HashMap();
        }
        this.incompleteInstances.put(this.contextual, incompleteInstance);
    }

    @Override
    public <S> WeldCreationalContext<S> getCreationalContext(Contextual<S> contextual) {
        return new CreationalContextImpl<S>(contextual, this.incompleteInstances, this.dependentInstances, this);
    }

    @Override
    public <S> S getIncompleteInstance(Contextual<S> bean) {
        return this.incompleteInstances == null ? null : (S)Reflections.cast(this.incompleteInstances.get(bean));
    }

    @Override
    public boolean containsIncompleteInstance(Contextual<?> bean) {
        return this.incompleteInstances != null && this.incompleteInstances.containsKey(bean);
    }

    @Override
    public void addDependentInstance(ContextualInstance<?> contextualInstance) {
        this.parentDependentInstances.add(contextualInstance);
    }

    @Override
    public void release() {
        this.release(null, null);
    }

    public void release(Contextual<T> contextual, T instance) {
        for (ContextualInstance<?> contextualInstance : this.dependentInstances) {
            if (contextual != null && contextualInstance.getContextual().equals(contextual)) continue;
            CreationalContextImpl.destroy(contextualInstance);
        }
        if (this.resourceReferences != null) {
            for (ResourceReference resourceReference : this.resourceReferences) {
                resourceReference.release();
            }
        }
    }

    private static <T> void destroy(ContextualInstance<T> beanInstance) {
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
    }

    @Override
    public WeldCreationalContext<?> getParentCreationalContext() {
        return this.parentCreationalContext;
    }

    @Override
    public Contextual<T> getContextual() {
        if (this.persistentContextual != null) {
            return this.persistentContextual;
        }
        return this.contextual;
    }

    @Override
    public void storeContextual() {
        if (this.contextual instanceof Bean) {
            Bean bean = (Bean)Reflections.cast(this.contextual);
            this.persistentContextual = this.contextual instanceof SerializableForwardingBean ? (SerializableForwardingBean)bean : new SerializableForwardingBean(bean);
        } else {
            throw new IllegalArgumentException("Unable to store " + this.contextual);
        }
    }

    @Override
    public InjectionPoint loadInjectionPoint() {
        return this.persistentInjectionPoint;
    }

    @Override
    public void storeInjectionPoint(InjectionPoint ip) {
        this.persistentInjectionPoint = ip instanceof SerializableForwardingInjectionPoint ? (SerializableForwardingInjectionPoint)ip : new SerializableForwardingInjectionPoint(ip);
    }

    @Override
    public List<ContextualInstance<?>> getDependentInstances() {
        return Collections.unmodifiableList(this.dependentInstances);
    }

    protected Object writeReplace() throws ObjectStreamException {
        Iterator<ContextualInstance<?>> iterator = this.dependentInstances.iterator();
        while (iterator.hasNext()) {
            ContextualInstance<?> instance = iterator.next();
            if (instance.getInstance() instanceof Serializable) continue;
            CreationalContextImpl.destroy(instance);
            iterator.remove();
        }
        return this;
    }

    @Override
    public void addDependentResourceReference(ResourceReference<?> resoruceReference) {
        if (this.resourceReferences == null) {
            this.resourceReferences = new ArrayList();
        }
        this.resourceReferences.add(resoruceReference);
    }

    @Override
    public boolean destroyDependentInstance(T instance) {
        Iterator<ContextualInstance<?>> iterator = this.dependentInstances.iterator();
        while (iterator.hasNext()) {
            ContextualInstance<?> contextualInstance = iterator.next();
            if (!contextualInstance.getInstance().equals(instance)) continue;
            iterator.remove();
            CreationalContextImpl.destroy(contextualInstance);
            return true;
        }
        return false;
    }
}

