/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.runtime.InvokableAnnotatedMethod;
import org.jboss.weld.injection.AbstractCallableInjectionPoint;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

public class MethodInjectionPoint<T, X>
extends AbstractCallableInjectionPoint<T, X, Method> {
    private final InvokableAnnotatedMethod<X> method;

    protected MethodInjectionPoint(EnhancedAnnotatedMethod<T, X> enhancedMethod, Bean<?> declaringBean, Class<?> declaringComponentClass, boolean observerOrDisposer, InjectionPointFactory factory, BeanManagerImpl manager) {
        super(enhancedMethod, declaringBean, declaringComponentClass, observerOrDisposer, factory, manager);
        this.method = new InvokableAnnotatedMethod<X>(enhancedMethod.slim());
    }

    public T invoke(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        return this.invokeWithSpecialValue(declaringInstance, null, null, manager, creationalContext, exceptionTypeToThrow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invokeWithSpecialValue(Object declaringInstance, Class<? extends Annotation> annotatedParameter, Object parameter, BeanManagerImpl manager, CreationalContext<?> ctx, Class<? extends RuntimeException> exceptionTypeToThrow) {
        CreationalContext invocationContext = manager.createCreationalContext((Contextual)null);
        try {
            Object x = this.method.invoke(declaringInstance, this.getParameterValues(annotatedParameter, parameter, manager, ctx, invocationContext));
            return (T)x;
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        finally {
            invocationContext.release();
        }
        return null;
    }

    public T invokeOnInstance(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        return this.invokeOnInstanceWithSpecialValue(declaringInstance, null, null, manager, creationalContext, exceptionTypeToThrow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invokeOnInstanceWithSpecialValue(Object declaringInstance, Class<? extends Annotation> annotatedParameter, Object parameter, BeanManagerImpl manager, CreationalContext<?> ctx, Class<? extends RuntimeException> exceptionTypeToThrow) {
        CreationalContext invocationContext = manager.createCreationalContext((Contextual)null);
        try {
            Object x = this.method.invokeOnInstance(declaringInstance, this.getParameterValues(annotatedParameter, parameter, manager, ctx, invocationContext));
            return (T)x;
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (SecurityException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (NoSuchMethodException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        finally {
            invocationContext.release();
        }
        return null;
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        throw new UnsupportedOperationException();
    }

    protected Object[] getParameterValues(Class<? extends Annotation> specialParam, Object specialVal, BeanManagerImpl manager, CreationalContext<?> ctx, CreationalContext<?> invocationContext) {
        Object[] parameterValues = new Object[this.getParameterInjectionPoints().size()];
        Iterator iterator = this.getParameterInjectionPoints().iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint param = iterator.next();
            parameterValues[i] = specialParam != null && param.getAnnotated().isAnnotationPresent(specialParam) ? specialVal : (param.getAnnotated().isAnnotationPresent(TransientReference.class) ? param.getValueToInject(manager, invocationContext) : param.getValueToInject(manager, ctx));
        }
        return parameterValues;
    }

    @Override
    public AnnotatedMethod<X> getAnnotated() {
        return this.method.delegate();
    }
}

