/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.runtime.RuntimeAnnotatedMembers;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.bean.proxy.DecoratorProxyFactory;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.SubclassedComponentInstantiator;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Decorators;

public class DecoratorInjectionTarget<T>
extends BeanInjectionTarget<T> {
    private final WeldInjectionPoint<?, ?> delegateInjectionPoint;

    public DecoratorInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        super(type, bean, beanManager);
        this.delegateInjectionPoint = Decorators.findDelegateInjectionPoint(type, this.getInjectionPoints());
        this.checkAbstractMethods(type);
    }

    @Override
    protected Instantiator<T> initInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Set<InjectionPoint> injectionPoints) {
        if (type.isAbstract()) {
            ConstructorInjectionPoint<T> originalConstructor = InjectionPointFactory.instance().createConstructorInjectionPoint(bean, type, beanManager);
            injectionPoints.addAll(originalConstructor.getParameterInjectionPoints());
            final WeldInjectionPoint<?, ?> delegateInjectionPoint = Decorators.findDelegateInjectionPoint(type, injectionPoints);
            return new SubclassedComponentInstantiator<T>(type, bean, originalConstructor, beanManager){

                @Override
                protected Class<T> createEnhancedSubclass(AnnotatedType<T> type, Bean<?> bean) {
                    return new DecoratorProxyFactory(type.getJavaClass(), delegateInjectionPoint, bean).getProxyClass();
                }
            };
        }
        DefaultInstantiator<T> instantiator = new DefaultInstantiator<T>(type, this.getBean(), beanManager);
        injectionPoints.addAll(instantiator.getConstructorInjectionPoint().getParameterInjectionPoints());
        return instantiator;
    }

    @Override
    protected void checkDelegateInjectionPoints() {
    }

    @Override
    public void inject(T instance, CreationalContext<T> ctx) {
        super.inject(instance, ctx);
        if (this.delegateInjectionPoint instanceof FieldInjectionPoint && instance instanceof DecoratorProxy) {
            Object delegate = RuntimeAnnotatedMembers.getFieldValue((AnnotatedField)this.delegateInjectionPoint.getAnnotated(), instance);
            ProxyMethodHandler handler = new ProxyMethodHandler(new TargetBeanInstance(delegate), this.getBean());
            ((ProxyObject)instance).setHandler(handler);
        }
    }

    @Override
    public void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
    }

    private void checkAbstractMethods(EnhancedAnnotatedType<T> type) {
        if (!type.isAbstract()) {
            return;
        }
        Set<Type> decoratedTypes = null;
        Bean bean = this.getBean();
        if (bean != null && bean instanceof DecoratorImpl) {
            decoratedTypes = ((DecoratorImpl)bean).getDecoratedTypes();
        }
        Decorators.checkAbstractMethods(decoratedTypes, type, this.beanManager);
    }
}

