/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.runtime.RuntimeAnnotatedMembers;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;

public class QualifierInstance {
    public static final QualifierInstance ANY = new QualifierInstance(Any.class);
    private final Class<? extends Annotation> annotationClass;
    private final Map<AnnotatedMethod<?>, Object> values;
    private final int hashCode;

    public static QualifierInstance of(Annotation annotation, MetaAnnotationStore store) {
        return new QualifierInstance(annotation, store);
    }

    public static Set<QualifierInstance> qualifiers(BeanManagerImpl beanManager, Set<Annotation> annotations) {
        return QualifierInstance.qualifiers(beanManager.getServices().get(MetaAnnotationStore.class), annotations);
    }

    public static Set<QualifierInstance> qualifiers(MetaAnnotationStore metaAnnotationStore, Set<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return Collections.emptySet();
        }
        ArraySet<QualifierInstance> ret = new ArraySet<QualifierInstance>();
        for (Annotation a : annotations) {
            ret.add(new QualifierInstance(a, metaAnnotationStore));
        }
        return WeldCollections.immutableSet(ret);
    }

    public static Set<QualifierInstance> qualifiers(BeanManagerImpl beanManager, Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).getQualifierInstances();
        }
        return QualifierInstance.qualifiers(beanManager, bean.getQualifiers());
    }

    public QualifierInstance(Annotation instance, MetaAnnotationStore store) {
        this(instance, instance.annotationType(), store);
    }

    private QualifierInstance(Annotation instance, Class<? extends Annotation> annotationClass, MetaAnnotationStore store) {
        this(annotationClass, QualifierInstance.createValues(instance, annotationClass, store));
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass) {
        this(annotationClass, Collections.emptyMap());
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass, Map<AnnotatedMethod<?>, Object> values) {
        this.annotationClass = annotationClass;
        this.values = values;
        this.hashCode = 31 * annotationClass.hashCode() + values.hashCode();
    }

    private static Map<AnnotatedMethod<?>, Object> createValues(Annotation instance, Class<? extends Annotation> annotationClass, MetaAnnotationStore store) {
        HashMap values = new HashMap();
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(annotationClass);
        for (AnnotatedMethod method : model.getAnnotatedAnnotation().getMethods()) {
            if (model.getNonBindingMembers().contains(method)) continue;
            try {
                AccessController.doPrivileged(SetAccessibleAction.of(method.getJavaMember()));
                values.put(method, RuntimeAnnotatedMembers.invokeMethod(method, instance, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new WeldException(e);
            }
            catch (InvocationTargetException e) {
                throw new WeldException(e);
            }
        }
        return WeldCollections.immutableMap(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifierInstance that = (QualifierInstance)o;
        if (!this.annotationClass.equals(that.annotationClass)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "QualifierInstance{annotationClass=" + this.annotationClass + ", values=" + this.values + ", hashCode=" + this.hashCode + '}';
    }
}

