/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.interceptor.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bean.proxy.EnterpriseBeanInstance;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.ejb.SessionBeanProxyInstantiator;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.InjectionTargetFactoryImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.reflection.Formats;

public class SessionBean<T>
extends AbstractClassBean<T> {
    private final InternalEjbDescriptor<T> ejbDescriptor;
    private Instantiator<T> proxyInstantiator;

    public static <T> SessionBean<T> of(BeanAttributes<T> attributes, InternalEjbDescriptor<T> ejbDescriptor, BeanManagerImpl beanManager, EnhancedAnnotatedType<T> type) {
        return new SessionBean<T>(attributes, type, ejbDescriptor, SessionBean.createId(SessionBean.class.getSimpleName(), ejbDescriptor, type), beanManager);
    }

    protected static String createId(String beanType, InternalEjbDescriptor<?> ejbDescriptor) {
        return beanType + "-" + ejbDescriptor.getEjbName();
    }

    protected static String createId(String beanType, InternalEjbDescriptor<?> ejbDescriptor, EnhancedAnnotatedType<?> type) {
        if (type.isDiscovered()) {
            return SessionBean.createId(beanType, ejbDescriptor);
        }
        return beanType + "-" + ejbDescriptor.getEjbName() + ((AnnotatedTypeIdentifier)type.slim().getIdentifier()).asString();
    }

    protected SessionBean(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, InternalEjbDescriptor<T> ejbDescriptor, String idSuffix, BeanManagerImpl manager) {
        super(attributes, type, idSuffix, manager);
        this.ejbDescriptor = ejbDescriptor;
        this.setProducer(((InjectionTargetFactoryImpl)this.beanManager.getInjectionTargetFactory((AnnotatedType)((Object)this.getEnhancedAnnotated()))).createInjectionTarget(this.getEnhancedAnnotated(), this));
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.checkEJBTypeAllowed();
        this.checkConflictingRoles();
        this.checkObserverMethods();
        this.checkScopeAllowed();
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException(BeanMessage.EJB_CANNOT_BE_INTERCEPTOR, this.getType());
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw new DefinitionException(BeanMessage.EJB_CANNOT_BE_DECORATOR, this.getType());
        }
    }

    protected void checkScopeAllowed() {
        if (this.ejbDescriptor.isStateless() && !this.isDependent()) {
            throw new DefinitionException(BeanMessage.SCOPE_NOT_ALLOWED_ON_STATELESS_SESSION_BEAN, this.getScope(), this.getType());
        }
        if (this.ejbDescriptor.isSingleton() && !this.isDependent() && !this.getScope().equals(ApplicationScoped.class)) {
            throw new DefinitionException(BeanMessage.SCOPE_NOT_ALLOWED_ON_SINGLETON_BEAN, this.getScope(), this.getType());
        }
    }

    @Override
    protected void specialize() {
        Set<AbstractBean<?, ?>> specializedBeans = this.getSpecializedBeans();
        if (specializedBeans.isEmpty()) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_ENTERPRISE_BEAN_MUST_EXTEND_AN_ENTERPRISE_BEAN, this);
        }
        for (AbstractBean<?, ?> specializedBean : specializedBeans) {
            if (specializedBean instanceof SessionBean) continue;
            throw new DefinitionException(BeanMessage.SPECIALIZING_ENTERPRISE_BEAN_MUST_EXTEND_AN_ENTERPRISE_BEAN, this);
        }
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        return this.proxyInstantiator.newInstance(creationalContext, this.beanManager, null);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (instance == null) {
            throw new IllegalArgumentException(BeanMessage.CANNOT_DESTROY_NULL_BEAN, this);
        }
        if (!(instance instanceof EnterpriseBeanInstance)) {
            throw new IllegalArgumentException(BeanMessage.CANNOT_DESTROY_ENTERPRISE_BEAN_NOT_CREATED, instance);
        }
        EnterpriseBeanInstance enterpriseBeanInstance = (EnterpriseBeanInstance)instance;
        enterpriseBeanInstance.destroy(Marker.INSTANCE, this, creationalContext);
        creationalContext.release();
    }

    private void checkEJBTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw new DefinitionException(BeanMessage.MESSAGE_DRIVEN_BEANS_CANNOT_BE_MANAGED, this);
        }
    }

    @Override
    protected void checkType() {
        if (!this.isDependent() && this.getEnhancedAnnotated().isGeneric()) {
            throw new DefinitionException(BeanMessage.GENERIC_SESSION_BEAN_MUST_BE_DEPENDENT, this);
        }
        boolean passivating = this.beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isPassivating();
        if (passivating && !this.isPassivationCapableBean()) {
            throw new DeploymentException(BeanMessage.PASSIVATING_BEAN_NEEDS_SERIALIZABLE_IMPL, this);
        }
    }

    public InternalEjbDescriptor<T> getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean isClientCanCallRemoveMethods() {
        return this.getEjbDescriptor().isStateful() && this.isDependent();
    }

    protected void checkObserverMethods() {
        Collection observerMethods = BeanMethods.getObserverMethods(this.getEnhancedAnnotated());
        if (!observerMethods.isEmpty()) {
            Set<MethodSignature> businessMethodSignatures = this.getBusinessMethodSignatures();
            for (EnhancedAnnotatedMethod observerMethod : observerMethods) {
                if (observerMethod.isStatic() || businessMethodSignatures.contains(observerMethod.getSignature())) continue;
                throw new DefinitionException(BeanMessage.OBSERVER_METHOD_MUST_BE_STATIC_OR_BUSINESS, observerMethod, this.getEnhancedAnnotated());
            }
        }
    }

    protected Set<MethodSignature> getBusinessMethodSignatures() {
        HashSet<MethodSignatureImpl> businessMethodSignatures = new HashSet<MethodSignatureImpl>();
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : this.ejbDescriptor.getLocalBusinessInterfaces()) {
            for (Method m : businessInterfaceDescriptor.getInterface().getMethods()) {
                businessMethodSignatures.add(new MethodSignatureImpl(m));
            }
        }
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : this.ejbDescriptor.getRemoteBusinessInterfaces()) {
            for (Method m : businessInterfaceDescriptor.getInterface().getMethods()) {
                businessMethodSignatures.add(new MethodSignatureImpl(m));
            }
        }
        return Collections.unmodifiableSet(businessMethodSignatures);
    }

    public SessionObjectReference createReference() {
        return this.beanManager.getServices().get(EjbServices.class).resolveEjb(this.getEjbDescriptor().delegate());
    }

    @Override
    protected boolean isInterceptionCandidate() {
        return true;
    }

    @Override
    public String toString() {
        return "Session bean [" + this.getBeanClass() + " with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "]; local interfaces are [" + Formats.formatBusinessInterfaceDescriptors(this.getEjbDescriptor().getLocalBusinessInterfaces()) + "]";
    }

    @Override
    public boolean isProxyable() {
        return true;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.ejbDescriptor.isPassivationCapable();
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return this.ejbDescriptor.isStateful() && this.isPassivationCapableBean() || this.ejbDescriptor.isSingleton() || this.ejbDescriptor.isStateless();
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        this.proxyInstantiator = new SessionBeanProxyInstantiator(this.enhancedAnnotatedItem, this);
        this.registerInterceptors();
    }

    protected void registerInterceptors() {
        InterceptionModel model = (InterceptionModel)this.beanManager.getInterceptorModelRegistry().get(this.getEjbDescriptor().getBeanClass());
        if (model != null) {
            this.getBeanManager().getServices().get(EjbServices.class).registerInterceptors(this.getEjbDescriptor(), new InterceptorBindingsAdapter(model));
        }
    }
}

