/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.NoopLifecycleCallbackInvoker;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorFactory;
import org.jboss.weld.manager.BeanManagerImpl;

public class ClassMetadataInterceptorFactory<T>
implements InterceptorFactory<T> {
    private final ClassMetadata<T> classMetadata;
    private final InjectionTarget<T> injectionTarget;

    public static <T> InterceptorFactory<T> of(ClassMetadata<T> classMetadata, BeanManagerImpl manager) {
        return new ClassMetadataInterceptorFactory<T>(classMetadata, manager);
    }

    private ClassMetadataInterceptorFactory(ClassMetadata<T> classMetadata, BeanManagerImpl manager) {
        this.classMetadata = classMetadata;
        this.injectionTarget = new InterceptorInjectionTarget<T>(manager.createEnhancedAnnotatedType(classMetadata.getJavaClass()), manager);
    }

    @Override
    public ClassMetadata<T> getClassMetadata() {
        return this.classMetadata;
    }

    @Override
    public T create(CreationalContext<T> ctx, BeanManager manager) {
        T instance = this.injectionTarget.produce(ctx);
        this.injectionTarget.inject(instance, ctx);
        return instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ClassMetadataInterceptorFactory) {
            ClassMetadataInterceptorFactory that = (ClassMetadataInterceptorFactory)o;
            return this.classMetadata.equals(that.classMetadata);
        }
        return false;
    }

    public int hashCode() {
        return this.classMetadata.hashCode();
    }

    public String toString() {
        return "ClassMetadataInterceptorFactory [class=" + this.classMetadata.getJavaClass().getName() + "]";
    }

    private static class InterceptorInjectionTarget<T>
    extends BasicInjectionTarget<T> {
        public InterceptorInjectionTarget(EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
            super(type, null, beanManager);
        }

        @Override
        protected LifecycleCallbackInvoker<T> initInvoker(EnhancedAnnotatedType<T> type) {
            return NoopLifecycleCallbackInvoker.getInstance();
        }
    }
}

