/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.Weld;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStoreImpl;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.BeanManagerBean;
import org.jboss.weld.bean.builtin.BeanManagerImplBean;
import org.jboss.weld.bean.builtin.ContextBean;
import org.jboss.weld.bean.proxy.util.SimpleProxyServices;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ConcurrentValidator;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.ExtensionBeanDeployer;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.TypeDiscoveryConfigurationImpl;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.events.AfterBeanDiscoveryImpl;
import org.jboss.weld.bootstrap.events.AfterDeploymentValidationImpl;
import org.jboss.weld.bootstrap.events.AfterTypeDiscoveryImpl;
import org.jboss.weld.bootstrap.events.BeforeBeanDiscoveryImpl;
import org.jboss.weld.bootstrap.events.BeforeShutdownImpl;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEventPreloader;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.SimpleAnnotationDiscovery;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.BootstrapConfiguration;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.FileBasedBootstrapConfiguration;
import org.jboss.weld.context.ApplicationContext;
import org.jboss.weld.context.DependentContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.SingletonContext;
import org.jboss.weld.context.bound.BoundConversationContext;
import org.jboss.weld.context.bound.BoundConversationContextImpl;
import org.jboss.weld.context.bound.BoundLiteral;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundRequestContextImpl;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.jboss.weld.context.bound.BoundSessionContextImpl;
import org.jboss.weld.context.ejb.EjbLiteral;
import org.jboss.weld.context.ejb.EjbRequestContext;
import org.jboss.weld.context.ejb.EjbRequestContextImpl;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpConversationContextImpl;
import org.jboss.weld.context.http.HttpLiteral;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.context.http.HttpSessionContextImpl;
import org.jboss.weld.context.unbound.ApplicationContextImpl;
import org.jboss.weld.context.unbound.DependentContextImpl;
import org.jboss.weld.context.unbound.RequestContextImpl;
import org.jboss.weld.context.unbound.SingletonContextImpl;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.event.GlobalObserverNotifierService;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.executor.ExecutorServicesFactory;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.SLSBInvocationInjectionPoint;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.logging.messages.VersionMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.BeanManagerLookupService;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.ReflectionCacheFactory;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.resources.SingleThreadScheduledExecutorServiceFactory;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.AnnotationDiscovery;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ScheduledExecutorServiceFactory;
import org.jboss.weld.serialization.ContextualStoreImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.ServiceLoader;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.jboss.weld.util.reflection.instantiation.LoaderInstantiatorFactory;
import org.jboss.weld.xml.BeansXmlParser;
import org.slf4j.cal10n.LocLogger;

public class WeldBootstrap
implements CDI11Bootstrap {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private BeanManagerImpl deploymentManager;
    private Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;
    private Environment environment;
    private Deployment deployment;
    private DeploymentVisitor deploymentVisitor;
    private final BeansXmlParser beansXmlParser;
    private Collection<ContextHolder<? extends Context>> contexts;
    private final ServiceRegistry initialServices = new SimpleServiceRegistry();

    public WeldBootstrap() {
        this.beansXmlParser = new BeansXmlParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDiscoveryConfiguration startExtensions(Iterable<Metadata<Extension>> extensions) {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            ImmutableSet<Class<? extends Annotation>> scopes = ImmutableSet.of(Dependent.class, RequestScoped.class, ConversationScoped.class, SessionScoped.class, ApplicationScoped.class);
            return new TypeDiscoveryConfigurationImpl(scopes);
        }
    }

    private void setupInitialServices() {
        if (this.initialServices.contains(TypeStore.class)) {
            return;
        }
        TypeStore store = new TypeStore();
        SharedObjectCache cache = new SharedObjectCache();
        ReflectionCache reflectionCache = ReflectionCacheFactory.newInstance(store);
        ClassTransformer classTransformer = new ClassTransformer(store, cache, reflectionCache);
        this.initialServices.add(TypeStore.class, store);
        this.initialServices.add(SharedObjectCache.class, cache);
        this.initialServices.add(ReflectionCache.class, reflectionCache);
        this.initialServices.add(ClassTransformer.class, classTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap startContainer(Environment environment, Deployment deployment) {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            if (deployment == null) {
                throw new IllegalArgumentException(BootstrapMessage.DEPLOYMENT_REQUIRED, new Object[0]);
            }
            ServiceRegistry registry = deployment.getServices();
            this.setupInitialServices();
            registry.addAll(this.initialServices.entrySet());
            if (!registry.contains(ResourceLoader.class)) {
                registry.add(ResourceLoader.class, DefaultResourceLoader.INSTANCE);
            }
            if (!registry.contains(InstantiatorFactory.class)) {
                registry.add(InstantiatorFactory.class, new LoaderInstantiatorFactory());
            }
            if (!registry.contains(ScheduledExecutorServiceFactory.class)) {
                registry.add(ScheduledExecutorServiceFactory.class, new SingleThreadScheduledExecutorServiceFactory());
            }
            if (!registry.contains(ProxyServices.class)) {
                registry.add(ProxyServices.class, new SimpleProxyServices());
            }
            if (!registry.contains(BootstrapConfiguration.class)) {
                registry.add(BootstrapConfiguration.class, new FileBasedBootstrapConfiguration(DefaultResourceLoader.INSTANCE));
            }
            WeldBootstrap.verifyServices(registry, environment.getRequiredDeploymentServices());
            if (!registry.contains(TransactionServices.class)) {
                log.info(BootstrapMessage.JTA_UNAVAILABLE, new Object[0]);
            }
            this.deployment = deployment;
            this.addImplementationServices(registry);
            SimpleServiceRegistry deploymentServices = new SimpleServiceRegistry();
            deploymentServices.add(ClassTransformer.class, registry.get(ClassTransformer.class));
            deploymentServices.add(SlimAnnotatedTypeStore.class, registry.get(SlimAnnotatedTypeStore.class));
            deploymentServices.add(MetaAnnotationStore.class, registry.get(MetaAnnotationStore.class));
            deploymentServices.add(TypeStore.class, registry.get(TypeStore.class));
            deploymentServices.add(ContextualStore.class, registry.get(ContextualStore.class));
            deploymentServices.add(CurrentInjectionPoint.class, registry.get(CurrentInjectionPoint.class));
            deploymentServices.add(GlobalObserverNotifierService.class, registry.get(GlobalObserverNotifierService.class));
            deploymentServices.add(ContainerLifecycleEvents.class, registry.get(ContainerLifecycleEvents.class));
            deploymentServices.add(SpecializationAndEnablementRegistry.class, registry.get(SpecializationAndEnablementRegistry.class));
            deploymentServices.add(ReflectionCache.class, registry.get(ReflectionCache.class));
            deploymentServices.add(GlobalEnablementBuilder.class, registry.get(GlobalEnablementBuilder.class));
            this.environment = environment;
            this.deploymentManager = BeanManagerImpl.newRootManager("deployment", deploymentServices);
            Container.initialize(this.deploymentManager, ServiceRegistries.unmodifiableServiceRegistry(registry));
            Container.instance().setState(ContainerState.STARTING);
            this.contexts = this.createContexts(deploymentServices);
            this.deploymentVisitor = new DeploymentVisitor(this.deploymentManager, environment, deployment, this.contexts);
            if (deployment instanceof CDI11Deployment) {
                registry.add(BeanManagerLookupService.class, new BeanManagerLookupService((CDI11Deployment)deployment, this.deploymentVisitor.managerAwareBeanDeploymentArchives));
            } else {
                log.warn("Legacy deployment metadata provided by the integrator. Certain functionality will not be available.");
            }
            this.beanDeployments = this.deploymentVisitor.visit();
            return this;
        }
    }

    private void addImplementationServices(ServiceRegistry services) {
        BootstrapConfiguration bootstrapConfiguration;
        services.add(SlimAnnotatedTypeStore.class, new SlimAnnotatedTypeStoreImpl());
        if (services.get(ClassTransformer.class) == null) {
            throw new RuntimeException();
        }
        services.add(MemberTransformer.class, new MemberTransformer(services.get(ClassTransformer.class)));
        services.add(MetaAnnotationStore.class, new MetaAnnotationStore(services.get(ClassTransformer.class)));
        services.add(ContextualStore.class, new ContextualStoreImpl());
        services.add(CurrentInjectionPoint.class, new CurrentInjectionPoint());
        services.add(SLSBInvocationInjectionPoint.class, new SLSBInvocationInjectionPoint());
        services.add(SpecializationAndEnablementRegistry.class, new SpecializationAndEnablementRegistry());
        GlobalObserverNotifierService observerNotificationService = new GlobalObserverNotifierService(services);
        services.add(GlobalObserverNotifierService.class, observerNotificationService);
        ExecutorServices executor = ExecutorServicesFactory.create(DefaultResourceLoader.INSTANCE);
        if (executor != null) {
            services.add(ExecutorServices.class, executor);
        }
        if (!services.contains(AnnotationDiscovery.class)) {
            services.add(AnnotationDiscovery.class, new SimpleAnnotationDiscovery(services.get(ReflectionCache.class)));
        }
        if ((bootstrapConfiguration = services.get(BootstrapConfiguration.class)).isConcurrentDeploymentEnabled() && services.contains(ExecutorServices.class)) {
            services.add(Validator.class, new ConcurrentValidator(executor));
        } else {
            services.add(Validator.class, new Validator());
        }
        ContainerLifecycleEventPreloader preloader = null;
        int preloaderThreadPoolSize = bootstrapConfiguration.getPreloaderThreadPoolSize();
        if (preloaderThreadPoolSize > 0) {
            preloader = new ContainerLifecycleEventPreloader(preloaderThreadPoolSize, observerNotificationService.getGlobalLenientObserverNotifier());
        }
        services.add(ContainerLifecycleEvents.class, new ContainerLifecycleEvents(preloader, services.get(AnnotationDiscovery.class)));
        services.add(GlobalEnablementBuilder.class, new GlobalEnablementBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanManagerImpl getManager(BeanDeploymentArchive beanDeploymentArchive) {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            BeanDeployment beanDeployment = this.beanDeployments.get(beanDeploymentArchive);
            if (beanDeployment != null) {
                return beanDeployment.getBeanManager().getCurrent();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap startInitialization() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            if (this.deploymentManager == null) {
                throw new org.jboss.weld.exceptions.IllegalStateException(BootstrapMessage.MANAGER_NOT_INITIALIZED, new Object[0]);
            }
            HashSet<BeanDeployment> physicalBeanDeploymentArchives = new HashSet<BeanDeployment>(this.beanDeployments.values());
            ExtensionBeanDeployer extensionBeanDeployer = new ExtensionBeanDeployer(this.deploymentManager, this.deployment, this.beanDeployments, this.contexts);
            extensionBeanDeployer.addExtensions(this.deployment.getExtensions());
            extensionBeanDeployer.deployBeans();
            this.deploymentManager.addBean(new BeanManagerBean(this.deploymentManager));
            this.deploymentManager.addBean(new BeanManagerImplBean(this.deploymentManager));
            this.beanDeployments = this.deploymentVisitor.visit();
            BeforeBeanDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.beanDeployments, this.contexts);
            for (BeanDeployment beanDeployment : physicalBeanDeploymentArchives) {
                beanDeployment.createClasses();
            }
            this.beanDeployments = this.deploymentVisitor.visit();
            for (BeanDeployment beanDeployment : this.beanDeployments.values()) {
                beanDeployment.createTypes();
            }
            AfterTypeDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.beanDeployments, this.contexts);
            for (BeanDeployment beanDeployment : this.beanDeployments.values()) {
                beanDeployment.createEnabled();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap deployBeans() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            for (BeanDeployment beanDeployment : this.beanDeployments.values()) {
                beanDeployment.createBeans(this.environment);
            }
            for (BeanDeployment beanDeployment : this.beanDeployments.values()) {
                beanDeployment.getBeanDeployer().processClassBeanAttributes();
                beanDeployment.getBeanDeployer().createProducersAndObservers();
            }
            for (BeanDeployment beanDeployment : this.beanDeployments.values()) {
                beanDeployment.getBeanDeployer().processProducerAttributes();
                beanDeployment.getBeanDeployer().createNewBeans();
            }
            for (Map.Entry entry : this.beanDeployments.entrySet()) {
                ((BeanDeployment)entry.getValue()).deploySpecialized(this.environment);
            }
            for (Map.Entry entry : this.beanDeployments.entrySet()) {
                ((BeanDeployment)entry.getValue()).deployBeans(this.environment);
            }
            AfterBeanDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.beanDeployments, this.contexts);
            this.beanDeployments = this.deploymentVisitor.visit();
            for (Map.Entry entry : this.beanDeployments.entrySet()) {
                ((BeanDeployment)entry.getValue()).getBeanManager().getServices().get(InjectionTargetService.class).initialize();
                ((BeanDeployment)entry.getValue()).afterBeanDiscovery(this.environment);
            }
            Container.instance().putBeanDeployments(this.beanDeployments);
            Container.instance().setState(ContainerState.DEPLOYED);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap validateBeans() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            log.debug(BootstrapMessage.VALIDATING_BEANS, new Object[0]);
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                BeanManagerImpl beanManager = entry.getValue().getBeanManager();
                beanManager.getBeanResolver().clear();
                this.deployment.getServices().get(Validator.class).validateDeployment(beanManager, entry.getValue());
                beanManager.getServices().get(InjectionTargetService.class).validate();
            }
            Container.instance().setState(ContainerState.VALIDATED);
            AfterDeploymentValidationImpl.fire(this.deploymentManager);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap endInitialization() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            this.deploymentManager.getBeanResolver().clear();
            this.deploymentManager.getAccessibleLenientObserverNotifier().clear();
            this.deploymentManager.getGlobalStrictObserverNotifier().clear();
            this.deploymentManager.getGlobalLenientObserverNotifier().clear();
            this.deploymentManager.getDecoratorResolver().clear();
            this.deploymentManager.getServices().cleanupAfterBoot();
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                BeanManagerImpl beanManager = entry.getValue().getBeanManager();
                beanManager.getBeanResolver().clear();
                beanManager.getAccessibleLenientObserverNotifier().clear();
                beanManager.getDecoratorResolver().clear();
                beanManager.getInterceptorMetadataReader().cleanAfterBoot();
                beanManager.getServices().cleanupAfterBoot();
                for (Bean<?> bean : beanManager.getBeans()) {
                    if (!(bean instanceof RIBean)) continue;
                    RIBean riBean = (RIBean)bean;
                    riBean.cleanupAfterBoot();
                }
                for (Decorator decorator : beanManager.getDecorators()) {
                    if (!(decorator instanceof DecoratorImpl)) continue;
                    ((DecoratorImpl)Reflections.cast(decorator)).cleanupAfterBoot();
                }
                for (Interceptor interceptor : beanManager.getInterceptors()) {
                    if (!(interceptor instanceof InterceptorImpl)) continue;
                    ((InterceptorImpl)Reflections.cast(interceptor)).cleanupAfterBoot();
                }
            }
            for (BeanDeployment deployment : this.beanDeployments.values()) {
                deployment.getBeanDeployer().cleanup();
            }
            Container.instance().setState(ContainerState.INITIALIZED);
            return this;
        }
    }

    protected Collection<ContextHolder<? extends Context>> createContexts(ServiceRegistry services) {
        ArrayList<ContextHolder<? extends Context>> contexts = new ArrayList<ContextHolder<? extends Context>>();
        contexts.add(new ContextHolder<ApplicationContext>(new ApplicationContextImpl(), ApplicationContext.class, UnboundLiteral.INSTANCE));
        contexts.add(new ContextHolder<SingletonContext>(new SingletonContextImpl(), SingletonContext.class, UnboundLiteral.INSTANCE));
        contexts.add(new ContextHolder<BoundSessionContext>(new BoundSessionContextImpl(), BoundSessionContext.class, BoundLiteral.INSTANCE));
        contexts.add(new ContextHolder<BoundConversationContext>(new BoundConversationContextImpl(), BoundConversationContext.class, BoundLiteral.INSTANCE));
        contexts.add(new ContextHolder<BoundRequestContext>(new BoundRequestContextImpl(), BoundRequestContext.class, BoundLiteral.INSTANCE));
        contexts.add(new ContextHolder<RequestContext>(new RequestContextImpl(), RequestContext.class, UnboundLiteral.INSTANCE));
        contexts.add(new ContextHolder<DependentContext>(new DependentContextImpl(services.get(ContextualStore.class)), DependentContext.class, UnboundLiteral.INSTANCE));
        if (Reflections.isClassLoadable("javax.servlet.ServletContext", WeldClassLoaderResourceLoader.INSTANCE)) {
            contexts.add(new ContextHolder<HttpSessionContext>(new HttpSessionContextImpl(), HttpSessionContext.class, HttpLiteral.INSTANCE));
            contexts.add(new ContextHolder<HttpConversationContext>(new HttpConversationContextImpl(), HttpConversationContext.class, HttpLiteral.INSTANCE));
            contexts.add(new ContextHolder<HttpRequestContext>(new HttpRequestContextImpl(), HttpRequestContext.class, HttpLiteral.INSTANCE));
        }
        if (this.deployment.getServices().contains(EjbServices.class)) {
            contexts.add(new ContextHolder<EjbRequestContext>(new EjbRequestContextImpl(), EjbRequestContext.class, EjbLiteral.INSTANCE));
        }
        for (ContextHolder contextHolder : contexts) {
            this.deploymentManager.addContext((Context)contextHolder.getContext());
            this.deploymentManager.addBean(ContextBean.of(contextHolder, this.deploymentManager));
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            try {
                ((ApplicationContext)this.deploymentManager.instance().select(ApplicationContext.class, new Annotation[0]).get()).invalidate();
            }
            finally {
                try {
                    BeforeShutdownImpl.fire(this.deploymentManager, this.beanDeployments);
                    Container.instance().setState(ContainerState.SHUTDOWN);
                    Container.instance().cleanup();
                }
                catch (Throwable throwable) {
                    Container.instance().setState(ContainerState.SHUTDOWN);
                    Container.instance().cleanup();
                    try {
                        CDI<Object> cdi = CDI.current();
                        if (cdi instanceof Weld) {
                            ((Weld)cdi).cleanup();
                        }
                    }
                    catch (IllegalStateException ignored) {}
                    throw throwable;
                }
                try {
                    CDI<Object> cdi = CDI.current();
                    if (cdi instanceof Weld) {
                        ((Weld)cdi).cleanup();
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    protected static void verifyServices(ServiceRegistry services, Set<Class<? extends Service>> requiredServices) {
        for (Class<? extends Service> serviceType : requiredServices) {
            if (services.contains(serviceType)) continue;
            throw new org.jboss.weld.exceptions.IllegalStateException(BootstrapMessage.UNSPECIFIED_REQUIRED_SERVICE, serviceType.getName());
        }
    }

    @Override
    public BeansXml parse(Iterable<URL> urls) {
        return this.parse(urls, false);
    }

    @Override
    public BeansXml parse(Iterable<URL> urls, boolean removeDuplicates) {
        return this.beansXmlParser.parse(urls, removeDuplicates);
    }

    @Override
    public BeansXml parse(URL url) {
        return this.beansXmlParser.parse(url);
    }

    @Override
    public Iterable<Metadata<Extension>> loadExtensions(ClassLoader classLoader) {
        return ServiceLoader.load(Extension.class, classLoader);
    }

    static {
        LoggerFactory.loggerFactory().getLogger(Category.VERSION).info(VersionMessage.VERSION, Formats.version(WeldBootstrap.class.getPackage()));
    }

    private static class DeploymentVisitor {
        private final BeanManagerImpl deploymentManager;
        private final Environment environment;
        private final Deployment deployment;
        private final Map<BeanDeploymentArchive, BeanDeployment> managerAwareBeanDeploymentArchives;
        private final Collection<ContextHolder<? extends Context>> contexts;

        public DeploymentVisitor(BeanManagerImpl deploymentManager, Environment environment, Deployment deployment, Collection<ContextHolder<? extends Context>> contexts) {
            this.deploymentManager = deploymentManager;
            this.environment = environment;
            this.deployment = deployment;
            this.contexts = contexts;
            this.managerAwareBeanDeploymentArchives = new ConcurrentHashMap<BeanDeploymentArchive, BeanDeployment>();
        }

        public Map<BeanDeploymentArchive, BeanDeployment> visit() {
            for (BeanDeploymentArchive archvive : this.deployment.getBeanDeploymentArchives()) {
                this.visit(archvive, this.managerAwareBeanDeploymentArchives, new HashSet<BeanDeploymentArchive>(), true);
            }
            return this.managerAwareBeanDeploymentArchives;
        }

        private <T extends Service> void copyService(BeanDeploymentArchive archive, Class<T> serviceClass) {
            T service;
            ServiceRegistry registry = archive.getServices();
            if (!registry.contains(serviceClass) && (service = this.deployment.getServices().get(serviceClass)) != null) {
                registry.add(serviceClass, service);
            }
        }

        private BeanDeployment visit(BeanDeploymentArchive beanDeploymentArchive, Map<BeanDeploymentArchive, BeanDeployment> managerAwareBeanDeploymentArchives, Set<BeanDeploymentArchive> seenBeanDeploymentArchives, boolean validate) {
            this.copyService(beanDeploymentArchive, ResourceLoader.class);
            this.copyService(beanDeploymentArchive, InstantiatorFactory.class);
            if (validate) {
                WeldBootstrap.verifyServices(beanDeploymentArchive.getServices(), this.environment.getRequiredBeanDeploymentArchiveServices());
            }
            if (beanDeploymentArchive.getId() == null) {
                throw new IllegalArgumentException(BootstrapMessage.DEPLOYMENT_ARCHIVE_NULL, beanDeploymentArchive);
            }
            BeanDeployment parent = managerAwareBeanDeploymentArchives.get(beanDeploymentArchive);
            if (parent == null) {
                parent = new BeanDeployment(beanDeploymentArchive, this.deploymentManager, this.deployment.getServices(), this.contexts);
                managerAwareBeanDeploymentArchives.put(beanDeploymentArchive, parent);
            }
            seenBeanDeploymentArchives.add(beanDeploymentArchive);
            for (BeanDeploymentArchive archive : beanDeploymentArchive.getBeanDeploymentArchives()) {
                BeanDeployment child = !seenBeanDeploymentArchives.contains(archive) ? this.visit(archive, managerAwareBeanDeploymentArchives, seenBeanDeploymentArchives, validate) : managerAwareBeanDeploymentArchives.get(archive);
                parent.getBeanManager().addAccessibleBeanManager(child.getBeanManager());
            }
            return parent;
        }
    }
}

