/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

public abstract class AbstractContainerEvent {
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final BeanManagerImpl beanManager;
    private final Type[] actualTypeArguments;
    private final Type rawType;
    private Object receiver;
    private ObserverMethod<?> observerMethod;

    protected AbstractContainerEvent(BeanManagerImpl beanManager, Type rawType, Type[] actualTypeArguments) {
        this.beanManager = beanManager;
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
    }

    protected List<Throwable> getErrors() {
        return this.errors;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public void fire() {
        ParameterizedTypeImpl eventType = new ParameterizedTypeImpl(this.getRawType(), this.getActualTypeArguments(), null);
        try {
            this.beanManager.getGlobalLenientObserverNotifier().fireEvent((Type)eventType, (Object)this, new Annotation[0]);
        }
        catch (Exception e) {
            this.getErrors().add(e);
        }
    }

    protected Type getRawType() {
        return this.rawType;
    }

    protected Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    public Object getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Object receiver) {
        this.receiver = receiver;
    }

    public ObserverMethod<?> getObserverMethod() {
        return this.observerMethod;
    }

    public void setObserverMethod(ObserverMethod<?> observerMethod) {
        this.observerMethod = observerMethod;
    }
}

