/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedCallable;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.serialization.ConstructorHolder;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_BAD_FIELD", "SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class BackedAnnotatedConstructor<X>
extends BackedAnnotatedCallable<X, Constructor<X>>
implements AnnotatedConstructor<X>,
Serializable {
    private final Constructor<X> constructor;

    public static <X> AnnotatedConstructor<X> of(Constructor<X> constructor, BackedAnnotatedType<X> declaringType, SharedObjectCache sharedObjectCache) {
        return new BackedAnnotatedConstructor<X>(constructor, declaringType, sharedObjectCache);
    }

    public BackedAnnotatedConstructor(Constructor<X> constructor, BackedAnnotatedType<X> declaringType, SharedObjectCache sharedObjectCache) {
        super(constructor, constructor.getDeclaringClass(), declaringType, sharedObjectCache);
        this.constructor = constructor;
    }

    @Override
    protected List<AnnotatedParameter<X>> initParameters(Constructor<X> member, SharedObjectCache sharedObjectCache) {
        Class<?>[] parameterTypes = member.getParameterTypes();
        Type[] genericParameterTypes = member.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = member.getParameterAnnotations();
        if (parameterTypes.length == genericParameterTypes.length && genericParameterTypes.length == parameterAnnotations.length) {
            ArrayList parameters = new ArrayList(parameterTypes.length);
            int nesting = Reflections.getNesting(((BackedAnnotatedType)this.getDeclaringType()).getJavaClass());
            for (int i = 0; i < parameterTypes.length; ++i) {
                int position;
                Type parameterType;
                int gi = i - nesting;
                Class<?> clazz = parameterTypes[i];
                if (member.getGenericParameterTypes().length > gi && gi >= 0) {
                    parameterType = member.getGenericParameterTypes()[gi];
                    position = gi;
                } else {
                    parameterType = clazz;
                    position = i;
                }
                parameters.add(new BackedAnnotatedParameter(parameterType, parameterAnnotations[position], position, this, sharedObjectCache));
            }
            return WeldCollections.immutableList(parameters);
        }
        return Collections.emptyList();
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.constructor;
    }

    @Override
    public Constructor<X> getJavaMember() {
        return this.constructor;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)this.constructor.getAnnotation(annotationType);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.constructor.isAnnotationPresent(annotationType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedConstructor other = (BackedAnnotatedConstructor)obj;
        return !(this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor));
    }

    public String toString() {
        return Formats.formatAnnotatedConstructor(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy<X>
    extends BackedAnnotatedMember.BackedAnnotatedMemberSerializationProxy<X, AnnotatedConstructor<X>> {
        private static final long serialVersionUID = -2726172060851333254L;

        public SerializationProxy(BackedAnnotatedConstructor<X> constructor) {
            super(constructor.getDeclaringType(), new ConstructorHolder(constructor.getJavaMember()));
        }

        private Object readResolve() throws ObjectStreamException {
            return this.resolve();
        }

        @Override
        protected Iterable<AnnotatedConstructor<X>> getCandidates() {
            return this.type.getConstructors();
        }
    }
}

