/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class AbstractBuiltInMetadataBean<T>
extends AbstractBuiltInBean<T> {
    private final CurrentInjectionPoint cip;

    public AbstractBuiltInMetadataBean(String idSuffix, Class<T> type, BeanManagerImpl beanManager) {
        super(idSuffix, beanManager, type);
        this.cip = beanManager.getServices().get(CurrentInjectionPoint.class);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        InjectionPoint ip = (InjectionPoint)this.cip.peek();
        if (ip == null) {
            throw new IllegalArgumentException(BeanMessage.DYNAMIC_LOOKUP_OF_BUILT_IN_NOT_ALLOWED, this.toString());
        }
        return this.newInstance(ip, creationalContext);
    }

    protected abstract T newInstance(InjectionPoint var1, CreationalContext<T> var2);

    protected WeldCreationalContext<?> getParentCreationalContext(CreationalContext<?> ctx) {
        WeldCreationalContext<?> parentContext;
        if (ctx instanceof WeldCreationalContext && (parentContext = ((WeldCreationalContext)ctx).getParentCreationalContext()) != null) {
            return parentContext;
        }
        throw new java.lang.IllegalArgumentException("Unable to determine parent creational context of " + ctx);
    }

    @Override
    public String toString() {
        return "Implicit Bean [" + this.getType().getName() + "] with qualifiers [@Default]";
    }
}

