/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.ConversationContextActivator;

public class ConversationFilter
implements Filter {
    static final String CONVERSATION_FILTER_INITIALIZED = ConversationFilter.class.getName() + ".initialized";
    @Inject
    private BeanManagerImpl manager;
    private ConversationContextActivator conversationContextActivator;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.conversationContextActivator = new ConversationContextActivator(this.manager, filterConfig.getServletContext());
        filterConfig.getServletContext().setAttribute(CONVERSATION_FILTER_INITIALIZED, (Object)Boolean.TRUE);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        this.conversationContextActivator.startConversationContext(httpRequest);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

