/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.interceptor.builder.BuildableInterceptionModel;
import org.jboss.weld.interceptor.builder.MethodReference;
import org.jboss.weld.interceptor.proxy.InterceptorException;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

class InterceptionModelImpl<T, I>
implements BuildableInterceptionModel<T, I> {
    private final Map<InterceptionType, List<InterceptorMetadata<I>>> globalInterceptors = new HashMap<InterceptionType, List<InterceptorMetadata<I>>>();
    private final Map<InterceptionType, Map<MethodReference, List<InterceptorMetadata<I>>>> methodBoundInterceptors = new HashMap<InterceptionType, Map<MethodReference, List<InterceptorMetadata<I>>>>();
    private final Set<MethodReference> methodsIgnoringGlobals = new HashSet<MethodReference>();
    private final Set<InterceptorMetadata<I>> allInterceptors = new LinkedHashSet<InterceptorMetadata<I>>();
    private final T interceptedEntity;
    private boolean hasTargetClassInterceptors;
    private boolean hasExternalNonConstructorInterceptors;

    public InterceptionModelImpl(T interceptedEntity) {
        this.interceptedEntity = interceptedEntity;
    }

    @Override
    public List<InterceptorMetadata<I>> getInterceptors(InterceptionType interceptionType, Method method) {
        if (InterceptionType.AROUND_CONSTRUCT.equals((Object)interceptionType)) {
            throw new IllegalStateException("Cannot use getInterceptors() for @AroundConstruct interceptor lookup. Use getConstructorInvocationInterceptors() instead.");
        }
        if (interceptionType.isLifecycleCallback() && method != null) {
            throw new IllegalArgumentException("On a lifecycle callback, the associated method must be null");
        }
        if (!interceptionType.isLifecycleCallback() && method == null) {
            throw new IllegalArgumentException("Around-invoke and around-timeout interceptors are defined for a given method");
        }
        if (interceptionType.isLifecycleCallback()) {
            if (this.globalInterceptors.containsKey((Object)interceptionType)) {
                return this.globalInterceptors.get((Object)interceptionType);
            }
        } else {
            List<InterceptorMetadata<I>> list;
            Map<MethodReference, List<InterceptorMetadata<I>>> map;
            MethodReference methodReference = InterceptionModelImpl.methodHolder(method);
            ArrayList<InterceptorMetadata<I>> returnedInterceptors = new ArrayList<InterceptorMetadata<I>>();
            if (!this.methodsIgnoringGlobals.contains(methodReference) && this.globalInterceptors.containsKey((Object)interceptionType)) {
                returnedInterceptors.addAll((Collection)this.globalInterceptors.get((Object)interceptionType));
            }
            if ((map = this.methodBoundInterceptors.get((Object)interceptionType)) != null && (list = map.get(methodReference)) != null) {
                returnedInterceptors.addAll(list);
            }
            return returnedInterceptors;
        }
        return Collections.emptyList();
    }

    @Override
    public Set<InterceptorMetadata<I>> getAllInterceptors() {
        return Collections.unmodifiableSet(this.allInterceptors);
    }

    @Override
    public T getInterceptedEntity() {
        return this.interceptedEntity;
    }

    @Override
    public void setIgnoresGlobals(Method method, boolean ignoresGlobals) {
        if (ignoresGlobals) {
            this.methodsIgnoringGlobals.add(InterceptionModelImpl.methodHolder(method));
        } else {
            this.methodsIgnoringGlobals.remove(InterceptionModelImpl.methodHolder(method));
        }
    }

    @Override
    public void appendInterceptors(InterceptionType interceptionType, Method method, InterceptorMetadata<I> ... interceptors) {
        if (interceptionType != InterceptionType.AROUND_CONSTRUCT) {
            this.hasExternalNonConstructorInterceptors = true;
        }
        if (null == method) {
            List<InterceptorMetadata<I>> interceptorsList = this.globalInterceptors.get((Object)interceptionType);
            if (interceptorsList == null) {
                interceptorsList = new ArrayList<InterceptorMetadata<I>>();
                this.globalInterceptors.put(interceptionType, interceptorsList);
            }
            this.appendInterceptorClassesToList(interceptionType, interceptorsList, interceptors);
        } else {
            List<InterceptorMetadata<I>> interceptorsList;
            MethodReference methodHolder = InterceptionModelImpl.methodHolder(method);
            if (null == this.methodBoundInterceptors.get((Object)interceptionType)) {
                this.methodBoundInterceptors.put(interceptionType, new HashMap());
            }
            if ((interceptorsList = this.methodBoundInterceptors.get((Object)interceptionType).get(methodHolder)) == null) {
                interceptorsList = new ArrayList<InterceptorMetadata<I>>();
                this.methodBoundInterceptors.get((Object)interceptionType).put(methodHolder, interceptorsList);
            }
            if (this.globalInterceptors.containsKey((Object)interceptionType) && !this.methodsIgnoringGlobals.contains(methodHolder)) {
                this.validateDuplicateInterceptors(interceptionType, this.globalInterceptors.get((Object)interceptionType), interceptors);
            }
            this.appendInterceptorClassesToList(interceptionType, interceptorsList, interceptors);
        }
        this.allInterceptors.addAll(Arrays.asList(interceptors));
    }

    private void appendInterceptorClassesToList(InterceptionType interceptionType, List<InterceptorMetadata<I>> interceptorsList, InterceptorMetadata<I> ... interceptors) {
        this.validateDuplicateInterceptors(interceptionType, interceptorsList, interceptors);
        interceptorsList.addAll(Arrays.asList(interceptors));
    }

    private void validateDuplicateInterceptors(InterceptionType interceptionType, List<InterceptorMetadata<I>> interceptorsList, InterceptorMetadata<I> ... interceptors) {
        for (InterceptorMetadata<I> interceptor : interceptors) {
            if (!interceptorsList.contains(interceptor) || interceptionType == null) continue;
            throw new InterceptorException("Duplicate interceptor class definition when binding " + interceptor.getInterceptorClass().getClassName() + " on " + interceptionType.name());
        }
    }

    private static MethodReference methodHolder(Method method) {
        return MethodReference.of(method, true);
    }

    @Override
    public List<InterceptorMetadata<I>> getConstructorInvocationInterceptors() {
        if (this.globalInterceptors.containsKey((Object)InterceptionType.AROUND_CONSTRUCT)) {
            return this.globalInterceptors.get((Object)InterceptionType.AROUND_CONSTRUCT);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasExternalConstructorInterceptors() {
        return !this.getConstructorInvocationInterceptors().isEmpty();
    }

    @Override
    public boolean hasExternalNonConstructorInterceptors() {
        return this.hasExternalNonConstructorInterceptors;
    }

    public void setHasTargetClassInterceptors(boolean hasTargetClassInterceptors) {
        this.hasTargetClassInterceptors = hasTargetClassInterceptors;
    }

    @Override
    public boolean hasTargetClassInterceptors() {
        return this.hasTargetClassInterceptors;
    }
}

