/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.TypeClosureLazyValueHolder;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public class SharedObjectCache
implements BootstrapService {
    private final Map<Set<?>, Set<?>> sharedSets = new MapMaker().makeComputingMap(new Function<Set<?>, Set<?>>(){

        @Override
        public Set<?> apply(Set<?> from) {
            return WeldCollections.immutableSet(from);
        }
    });
    private final Map<Map<?, ?>, Map<?, ?>> sharedMaps = new MapMaker().makeComputingMap(new Function<Map<?, ?>, Map<?, ?>>(){

        @Override
        public Map<?, ?> apply(Map<?, ?> from) {
            return WeldCollections.immutableMap(from);
        }
    });
    private final Map<ArraySetMultimap<?, ?>, ArraySetMultimap<?, ?>> sharedMultiMaps = new MapMaker().makeComputingMap(new Function<ArraySetMultimap<?, ?>, ArraySetMultimap<?, ?>>(){

        @Override
        public ArraySetMultimap<?, ?> apply(ArraySetMultimap<?, ?> from) {
            return from;
        }
    });
    private final Map<Type, LazyValueHolder<Set<Type>>> typeClosureHolders = new MapMaker().makeComputingMap(new Function<Type, LazyValueHolder<Set<Type>>>(){

        @Override
        public LazyValueHolder<Set<Type>> apply(Type input) {
            return new TypeClosureLazyValueHolder(input);
        }
    });
    private final Map<Type, Type> resolvedTypes = new MapMaker().makeComputingMap(new Function<Type, Type>(){

        @Override
        public Type apply(Type from) {
            return Types.getCanonicalType(from);
        }
    });

    public static SharedObjectCache instance(BeanManagerImpl manager) {
        return manager.getServices().get(SharedObjectCache.class);
    }

    public <T> Set<T> getSharedSet(Set<T> set) {
        return (Set)Reflections.cast(this.sharedSets.get(set));
    }

    public <K, V> Map<K, V> getSharedMap(Map<K, V> map) {
        return (Map)Reflections.cast(this.sharedMaps.get(map));
    }

    public <K, V> ArraySetMultimap<K, V> getSharedMultimap(ArraySetMultimap<K, V> map) {
        return (ArraySetMultimap)Reflections.cast(this.sharedMultiMaps.get(map));
    }

    public LazyValueHolder<Set<Type>> getTypeClosureHolder(Type type) {
        return this.typeClosureHolders.get(type);
    }

    public Type getResolvedType(Type type) {
        return this.resolvedTypes.get(type);
    }

    @Override
    public void cleanupAfterBoot() {
        this.sharedSets.clear();
        this.sharedMaps.clear();
        this.sharedMultiMaps.clear();
        this.typeClosureHolders.clear();
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
        this.resolvedTypes.clear();
    }
}

