/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Decorated;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Scope;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.CommonBean;
import org.jboss.weld.bean.DecorableBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.AbstractDecorableBuiltInBean;
import org.jboss.weld.bean.builtin.ee.EEResourceProducerField;
import org.jboss.weld.bean.interceptor.CdiInterceptorFactory;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.InconsistentSpecializationException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.exceptions.UnserializableDependencyException;
import org.jboss.weld.injection.producer.AbstractMemberProducer;
import org.jboss.weld.interceptor.reader.ClassMetadataInterceptorFactory;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.literal.DecoratedLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.literal.InterceptedLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Decorators;
import org.jboss.weld.util.JtaApiAbstraction;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.collections.HashSetSupplier;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class Validator
implements Service {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);

    protected void validateGeneralBean(Bean<?> bean, BeanManagerImpl beanManager) {
        UnproxyableResolutionException ue;
        for (InjectionPoint ij : bean.getInjectionPoints()) {
            this.validateInjectionPoint(ij, beanManager);
        }
        boolean normalScoped = beanManager.isNormalScope(bean.getScope());
        if (normalScoped && bean.getName() != null && !Beans.isBeanProxyable(bean) && (ue = Proxies.getUnproxyableTypesException(bean)) != null) {
            throw new DeploymentException(ue);
        }
        if (!normalScoped) {
            Validator.validatePseudoScopedBean(bean, beanManager);
        }
        if (beanManager.isPassivatingScope(bean.getScope()) && !Beans.isPassivationCapableBean(bean)) {
            throw new DeploymentException(ValidatorMessage.BEAN_WITH_PASSIVATING_SCOPE_NOT_PASSIVATION_CAPABLE, bean);
        }
    }

    protected void validateRIBean(CommonBean<?> bean, BeanManagerImpl beanManager, Collection<CommonBean<?>> specializedBeans) {
        AbstractMemberProducer producer;
        AbstractProducerBean producerBean;
        AbstractClassBean classBean;
        this.validateGeneralBean(bean, beanManager);
        if (bean instanceof NewBean) {
            return;
        }
        if (bean instanceof DecorableBean) {
            this.validateDecorators(beanManager, (DecorableBean)((Object)bean));
        }
        if (bean instanceof AbstractClassBean && (classBean = (AbstractClassBean)bean).hasInterceptors()) {
            this.validateInterceptors(beanManager, classBean);
        }
        if (bean instanceof AbstractProducerBean && (producerBean = (AbstractProducerBean)Reflections.cast(bean)).getProducer() instanceof AbstractMemberProducer && (producer = (AbstractMemberProducer)Reflections.cast(producerBean.getProducer())).getDisposalMethod() != null) {
            for (InjectionPoint ip : producer.getDisposalMethod().getInjectionPoints()) {
                this.validateInjectionPointForDefinitionErrors(ip, null, beanManager);
                this.validateMetadataInjectionPoint(ip, null, ValidatorMessage.INJECTION_INTO_DISPOSER_METHOD);
                this.validateEventMetadataInjectionPoint(ip);
                this.validateInjectionPointForDeploymentProblems(ip, null, beanManager);
            }
        }
    }

    private void validateCustomBean(Bean<?> bean, BeanManagerImpl beanManager) {
        this.validateGeneralBean(bean, beanManager);
        if (!(bean instanceof PassivationCapable) && beanManager.isNormalScope(bean.getScope())) {
            log.warn(ValidatorMessage.BEAN_NOT_PASSIVATION_CAPABLE, bean);
        }
    }

    private void validateInterceptors(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        Set<InterceptorMetadata<?>> interceptors;
        InterceptionModel interceptionModel = (InterceptionModel)beanManager.getInterceptorModelRegistry().get(classBean.getType());
        if (interceptionModel != null && (interceptors = interceptionModel.getAllInterceptors()).size() > 0) {
            boolean passivationCapabilityCheckRequired = beanManager.isPassivatingScope(classBean.getScope());
            for (InterceptorMetadata<?> interceptorMetadata : interceptors) {
                Bean resolvedBean;
                if (interceptorMetadata.getInterceptorFactory() instanceof CdiInterceptorFactory) {
                    CdiInterceptorFactory cdiInterceptorFactory = (CdiInterceptorFactory)interceptorMetadata.getInterceptorFactory();
                    Interceptor interceptor = cdiInterceptorFactory.getInterceptor();
                    if (passivationCapabilityCheckRequired) {
                        boolean isSerializable;
                        boolean bl = isSerializable = interceptor instanceof InterceptorImpl ? ((InterceptorImpl)interceptor).isSerializable() : Beans.isPassivationCapableDependency(interceptor);
                        if (!isSerializable) {
                            throw new DeploymentException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_INTERCEPTOR, classBean, interceptor);
                        }
                    }
                    for (InjectionPoint injectionPoint : interceptor.getInjectionPoints()) {
                        resolvedBean = beanManager.resolve(beanManager.getBeans(injectionPoint));
                        if (!passivationCapabilityCheckRequired) continue;
                        this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                    }
                }
                if (!(interceptorMetadata.getInterceptorFactory() instanceof ClassMetadataInterceptorFactory)) continue;
                ClassMetadataInterceptorFactory factory = (ClassMetadataInterceptorFactory)interceptorMetadata.getInterceptorFactory();
                ClassMetadata<?> classMetadata = interceptorMetadata.getInterceptorClass();
                if (passivationCapabilityCheckRequired && !Reflections.isSerializable(classMetadata.getJavaClass())) {
                    throw new DeploymentException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_INTERCEPTOR, this, classMetadata.getJavaClass().getName());
                }
                for (InjectionPoint injectionPoint : factory.getInjectionTarget().getInjectionPoints()) {
                    this.validateInjectionPoint(injectionPoint, beanManager);
                    if (!passivationCapabilityCheckRequired) continue;
                    resolvedBean = beanManager.resolve(beanManager.getBeans(injectionPoint));
                    this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                }
            }
        }
    }

    private void validateDecorators(BeanManagerImpl beanManager, DecorableBean<?> bean) {
        if (!beanManager.isPassivatingScope(bean.getScope()) && !(bean instanceof AbstractDecorableBuiltInBean)) {
            return;
        }
        List<Decorator<?>> decorators = bean.getDecorators();
        if (decorators.isEmpty()) {
            return;
        }
        for (Decorator<?> decorator : decorators) {
            if (!Decorators.isPassivationCapable(decorator)) {
                if (bean instanceof AbstractDecorableBuiltInBean) {
                    throw new UnserializableDependencyException(ValidatorMessage.BUILTIN_BEAN_WITH_NONSERIALIZABLE_DECORATOR, decorator, bean);
                }
                throw new UnserializableDependencyException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_DECORATOR, bean, decorator);
            }
            for (InjectionPoint ij : decorator.getInjectionPoints()) {
                if (ij.isDelegate()) continue;
                Bean resolvedBean = beanManager.resolve(beanManager.getBeans(ij));
                this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
            }
        }
    }

    public void validateInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager) {
        this.validateInjectionPointForDefinitionErrors(ij, ij.getBean(), beanManager);
        this.validateMetadataInjectionPoint(ij, ij.getBean(), ValidatorMessage.INJECTION_INTO_NON_BEAN);
        this.validateEventMetadataInjectionPoint(ij);
        this.validateInjectionPointForDeploymentProblems(ij, ij.getBean(), beanManager);
    }

    public void validateInjectionPointForDefinitionErrors(InjectionPoint ij, Bean<?> bean, BeanManagerImpl beanManager) {
        boolean newBean;
        if (ij.getAnnotated().getAnnotation(New.class) != null && ij.getQualifiers().size() > 1) {
            throw new DefinitionException(ValidatorMessage.NEW_WITH_QUALIFIERS, ij);
        }
        if (ij.getType() instanceof TypeVariable) {
            throw new DefinitionException(ValidatorMessage.INJECTION_POINT_WITH_TYPE_VARIABLE, ij);
        }
        if (!(ij.getMember() instanceof Field) && ij.getAnnotated().isAnnotationPresent(Named.class) && ij.getAnnotated().getAnnotation(Named.class).value().equals("")) {
            throw new DefinitionException(ValidatorMessage.NON_FIELD_INJECTION_POINT_CANNOT_USE_NAMED, ij);
        }
        if (ij.getAnnotated().isAnnotationPresent(Produces.class)) {
            if (bean != null) {
                throw new DefinitionException(BeanMessage.INJECTED_FIELD_CANNOT_BE_PRODUCER, ij.getAnnotated(), bean);
            }
            throw new DefinitionException(BeanMessage.INJECTED_FIELD_CANNOT_BE_PRODUCER, ij.getAnnotated(), ((AnnotatedField)Reflections.cast(ij.getAnnotated())).getDeclaringType());
        }
        boolean bl = newBean = bean instanceof NewManagedBean || bean instanceof NewSessionBean;
        if (!newBean) {
            this.checkScopeAnnotations(ij, beanManager.getServices().get(MetaAnnotationStore.class));
        }
        Validator.checkFacadeInjectionPoint(ij, Instance.class);
        Validator.checkFacadeInjectionPoint(ij, Event.class);
        if (bean instanceof SessionBean) {
            JtaApiAbstraction jtaApi = beanManager.getServices().get(JtaApiAbstraction.class);
            if (jtaApi.USER_TRANSACTION_CLASS.equals(ij.getType()) && (ij.getQualifiers().isEmpty() || ij.getQualifiers().contains(DefaultLiteral.INSTANCE)) && beanManager.getServices().get(EJBApiAbstraction.class).isSessionBeanWithContainerManagedTransactions(bean)) {
                throw new DefinitionException(ValidatorMessage.USER_TRANSACTION_INJECTION_INTO_BEAN_WITH_CONTAINER_MANAGED_TRANSACTIONS, ij);
            }
        }
    }

    public void validateMetadataInjectionPoint(InjectionPoint ij, Bean<?> bean, ValidatorMessage message) {
        if (ij.getType().equals(InjectionPoint.class) && bean == null) {
            throw new DefinitionException(message, ij);
        }
        if (ij.getType().equals(InjectionPoint.class) && !Dependent.class.equals(bean.getScope())) {
            throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_DEPENDENT_BEAN, ij);
        }
        Class rawType = Reflections.getRawType(ij.getType());
        if (Bean.class.equals(rawType) || Interceptor.class.equals(rawType) || Decorator.class.equals(rawType)) {
            if (bean == null) {
                throw new DefinitionException(message, ij);
            }
            if (bean instanceof AbstractClassBean) {
                Validator.checkBeanMetadataInjectionPoint(bean, ij, AnnotatedTypes.getDeclaringAnnotatedType(ij.getAnnotated()).getBaseType());
            }
            if (bean instanceof ProducerMethod) {
                ProducerMethod producerMethod = (ProducerMethod)Reflections.cast(bean);
                Validator.checkBeanMetadataInjectionPoint(bean, ij, producerMethod.getAnnotated().getBaseType());
            }
        }
    }

    public void validateEventMetadataInjectionPoint(InjectionPoint ip) {
        if (EventMetadata.class.equals((Object)ip.getType()) && ip.getQualifiers().contains(DefaultLiteral.INSTANCE)) {
            throw new DefinitionException(ValidatorMessage.EVENT_METADATA_INJECTED_OUTSIDE_OF_OBSERVER, ip);
        }
    }

    public void validateInjectionPointForDeploymentProblems(InjectionPoint ij, Bean<?> bean, BeanManagerImpl beanManager) {
        if (ij.isDelegate()) {
            return;
        }
        Set resolvedBeans = beanManager.getBeanResolver().resolve(beanManager.getBeans(ij));
        if (!Validator.isInjectionPointSatisfied(ij, resolvedBeans, beanManager)) {
            throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_UNSATISFIED_DEPENDENCIES, ij, Formats.formatAnnotations(ij.getQualifiers().toArray(new Annotation[ij.getQualifiers().size()])), Formats.formatType(ij.getType()));
        }
        if (resolvedBeans.size() > 1) {
            throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_AMBIGUOUS_DEPENDENCIES, ij, Formats.formatAnnotations(ij.getQualifiers().toArray(new Annotation[ij.getQualifiers().size()])), Formats.formatType(ij.getType()), resolvedBeans);
        }
        if (!resolvedBeans.isEmpty()) {
            UnproxyableResolutionException ue;
            Bean resolvedBean = resolvedBeans.iterator().next();
            if (beanManager.isNormalScope(resolvedBean.getScope()) && (ue = Proxies.getUnproxyableTypeException(ij.getType(), resolvedBean)) != null) {
                throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_NON_PROXYABLE_DEPENDENCIES, (Throwable)ue, ij);
            }
            if (bean != null && Beans.isPassivatingScope(bean, beanManager)) {
                this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
            }
        }
    }

    public void validateProducers(Collection<Producer<?>> producers, BeanManagerImpl beanManager) {
        for (Producer<?> producer : producers) {
            this.validateProducer(producer, beanManager);
        }
    }

    public void validateProducer(Producer<?> producer, BeanManagerImpl beanManager) {
        for (InjectionPoint injectionPoint : producer.getInjectionPoints()) {
            this.validateInjectionPoint(injectionPoint, beanManager);
        }
    }

    private void checkScopeAnnotations(InjectionPoint ij, MetaAnnotationStore metaAnnotationStore) {
        Annotated annotated = ij.getAnnotated();
        if (annotated instanceof EnhancedAnnotated) {
            EnhancedAnnotated weldAnnotated = (EnhancedAnnotated)annotated;
            Set<Annotation> scopes = weldAnnotated.getMetaAnnotations(Scope.class);
            Set<Annotation> normalScopes = weldAnnotated.getMetaAnnotations(NormalScope.class);
            for (Annotation annotation : scopes) {
                this.logScopeOnInjectionPointWarning(ij, annotation);
            }
            for (Annotation annotation : normalScopes) {
                this.logScopeOnInjectionPointWarning(ij, annotation);
            }
        } else {
            for (Annotation annotation : annotated.getAnnotations()) {
                if (!this.hasScopeMetaAnnotation(annotation)) continue;
                this.logScopeOnInjectionPointWarning(ij, annotation);
            }
        }
    }

    private void logScopeOnInjectionPointWarning(InjectionPoint ij, Annotation annotation) {
        log.warn(ValidatorMessage.SCOPE_ANNOTATION_ON_INJECTION_POINT, annotation, ij);
    }

    private boolean hasScopeMetaAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.isAnnotationPresent(Scope.class) || annotationType.isAnnotationPresent(NormalScope.class);
    }

    public void validateInjectionPointPassivationCapable(InjectionPoint ij, Bean<?> resolvedBean, BeanManagerImpl beanManager) {
        if (!Beans.isPassivationCapableDependency(resolvedBean)) {
            if (ij.getMember() instanceof Field && ij.isTransient()) {
                return;
            }
            if (ij.getAnnotated() instanceof AnnotatedParameter && ij.getAnnotated().isAnnotationPresent(TransientReference.class)) {
                return;
            }
            throw new UnserializableDependencyException(ValidatorMessage.INJECTION_POINT_HAS_NON_SERIALIZABLE_DEPENDENCY, ij.getBean(), resolvedBean);
        }
    }

    public void validateDeployment(BeanManagerImpl manager, BeanDeployment deployment) {
        this.validateDecorators(manager.getDecorators(), manager);
        this.validateInterceptors(manager.getInterceptors(), manager);
        this.validateBeans(manager.getBeans(), manager);
        this.validateEnabledDecoratorClasses(manager, deployment);
        this.validateEnabledInterceptorClasses(manager, deployment);
        this.validateEnabledAlternativeStereotypes(manager, deployment);
        this.validateEnabledAlternativeClasses(manager, deployment);
        this.validateSpecialization(manager);
        this.validateDisposalMethods((BeanDeployerEnvironment)deployment.getBeanDeployer().getEnvironment());
        this.validateObserverMethods(((BeanDeployerEnvironment)deployment.getBeanDeployer().getEnvironment()).getObservers(), manager);
        this.validateBeanNames(manager);
    }

    public void validateSpecialization(BeanManagerImpl manager) {
        SpecializationAndEnablementRegistry registry = manager.getServices().get(SpecializationAndEnablementRegistry.class);
        for (Multiset.Entry<AbstractBean<?, ?>> entry : registry.getBeansSpecializedInAnyDeploymentAsMultiset().entrySet()) {
            if (entry.getCount() <= 1) continue;
            throw new InconsistentSpecializationException(ValidatorMessage.BEAN_SPECIALIZED_TOO_MANY_TIMES, entry.getElement());
        }
    }

    public void validateBeans(Collection<? extends Bean<?>> beans, BeanManagerImpl manager) {
        ArrayList<RuntimeException> problems = new ArrayList<RuntimeException>();
        HashSet specializedBeans = new HashSet();
        for (Bean<?> bean : beans) {
            this.validateBean(bean, specializedBeans, manager, problems);
        }
        if (!problems.isEmpty()) {
            if (problems.size() == 1) {
                throw (RuntimeException)problems.get(0);
            }
            throw new DeploymentException(problems);
        }
    }

    protected void validateBean(Bean<?> bean, Collection<CommonBean<?>> specializedBeans, BeanManagerImpl manager, List<RuntimeException> problems) {
        try {
            if (bean instanceof CommonBean) {
                this.validateRIBean((CommonBean)bean, manager, specializedBeans);
            } else {
                this.validateCustomBean(bean, manager);
            }
        }
        catch (RuntimeException e) {
            problems.add(e);
        }
    }

    public void validateInterceptors(Collection<? extends Interceptor<?>> interceptors, BeanManagerImpl manager) {
        for (Interceptor<?> interceptor : interceptors) {
            this.validateInterceptor(interceptor, manager);
        }
    }

    protected void validateInterceptor(Interceptor<?> interceptor, BeanManagerImpl manager) {
        if (interceptor instanceof InterceptorImpl) {
            EnhancedAnnotatedType annotated = ((InterceptorImpl)interceptor).getEnhancedAnnotated();
            if (!BeanMethods.getObserverMethods(annotated).isEmpty()) {
                throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_OBSERVER_METHODS, interceptor);
            }
            while (annotated != null && annotated.getJavaClass() != Object.class) {
                if (!annotated.getDeclaredEnhancedMethods(Produces.class).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_PRODUCER_METHODS, interceptor);
                }
                if (!annotated.getDeclaredEnhancedFields(Produces.class).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_PRODUCER_FIELDS, interceptor);
                }
                if (!annotated.getDeclaredEnhancedMethodsWithAnnotatedParameters(Disposes.class).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_DISPOSER_METHODS, interceptor);
                }
                annotated = annotated.getEnhancedSuperclass();
            }
        }
        for (InjectionPoint injectionPoint : interceptor.getInjectionPoints()) {
            this.validateInjectionPoint(injectionPoint, manager);
        }
    }

    public void validateDecorators(Collection<? extends Decorator<?>> decorators, BeanManagerImpl manager) {
        HashSet specializedBeans = new HashSet();
        for (Decorator<?> decorator : decorators) {
            this.validateDecorator(decorator, specializedBeans, manager);
        }
    }

    protected void validateDecorator(Decorator<?> decorator, Collection<CommonBean<?>> specializedBeans, BeanManagerImpl manager) {
        if (decorator.getDecoratedTypes().isEmpty()) {
            throw new DefinitionException(ValidatorMessage.NO_DECORATED_TYPES, decorator);
        }
        Decorators.checkDelegateType(decorator);
        Type delegateType = decorator.getDelegateType();
        if (delegateType instanceof ParameterizedType) {
            ParameterizedType parameterizedDelegateType = (ParameterizedType)delegateType;
            if (!Decorators.isPassivationCapable(decorator)) {
                if (Instance.class.equals((Object)parameterizedDelegateType.getRawType()) || Provider.class.equals((Object)parameterizedDelegateType.getRawType())) {
                    throw new UnserializableDependencyException(ValidatorMessage.BUILTIN_BEAN_WITH_NONSERIALIZABLE_DECORATOR, decorator, Instance.class.getName());
                }
                if (Event.class.equals((Object)parameterizedDelegateType.getRawType())) {
                    throw new UnserializableDependencyException(ValidatorMessage.BUILTIN_BEAN_WITH_NONSERIALIZABLE_DECORATOR, decorator, Event.class.getName());
                }
            }
        }
        if (decorator instanceof WeldDecorator) {
            EnhancedAnnotatedType<?> annotated;
            if (decorator instanceof DecoratorImpl) {
                this.validateRIBean((CommonBean)((Object)decorator), manager, specializedBeans);
                if (!BeanMethods.getObserverMethods(annotated).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_OBSERVER_METHODS, decorator);
                }
                for (annotated = ((WeldDecorator)decorator).getEnhancedAnnotated(); annotated != null && annotated.getJavaClass() != Object.class; annotated = annotated.getEnhancedSuperclass()) {
                    if (!annotated.getDeclaredEnhancedMethods(Produces.class).isEmpty()) {
                        throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_PRODUCER_METHODS, decorator);
                    }
                    if (!annotated.getDeclaredEnhancedFields(Produces.class).isEmpty()) {
                        throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_PRODUCER_FIELDS, decorator);
                    }
                    if (annotated.getDeclaredEnhancedMethodsWithAnnotatedParameters(Disposes.class).isEmpty()) continue;
                    throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_DISPOSER_METHODS, decorator);
                }
            } else {
                this.validateGeneralBean(decorator, manager);
                Decorators.findDelegateInjectionPoint(annotated, decorator.getInjectionPoints());
            }
        }
    }

    public void validateBeanNames(BeanManagerImpl beanManager) {
        SetMultimap namedAccessibleBeans = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        for (Bean<?> bean : beanManager.getAccessibleBeans()) {
            if (bean.getName() == null) continue;
            namedAccessibleBeans.put(bean.getName(), bean);
        }
        ArrayList<String> accessibleNamespaces = new ArrayList<String>();
        for (String namespace : beanManager.getAccessibleNamespaces()) {
            accessibleNamespaces.add(namespace);
        }
        SpecializationAndEnablementRegistry registry = beanManager.getServices().get(SpecializationAndEnablementRegistry.class);
        for (String name : namedAccessibleBeans.keySet()) {
            Set resolvedBeans = beanManager.getBeanResolver().resolve(Beans.removeDisabledAndSpecializedBeans(namedAccessibleBeans.get(name), beanManager, registry));
            if (resolvedBeans.size() > 1) {
                throw new DeploymentException(ValidatorMessage.AMBIGUOUS_EL_NAME, name, resolvedBeans);
            }
            if (!accessibleNamespaces.contains(name)) continue;
            throw new DeploymentException(ValidatorMessage.BEAN_NAME_IS_PREFIX, name);
        }
    }

    private void validateEnabledInterceptorClasses(BeanManagerImpl beanManager, BeanDeployment deployment) {
        BeansXml beansXml = deployment.getBeanDeploymentArchive().getBeansXml();
        if (beansXml != null && !beansXml.getEnabledInterceptors().isEmpty()) {
            HashSet<String> interceptorBeanClasses = new HashSet<String>();
            for (Interceptor<?> interceptor : beanManager.getAccessibleInterceptors()) {
                interceptorBeanClasses.add(interceptor.getBeanClass().getName());
            }
            for (Metadata metadata : beansXml.getEnabledInterceptors()) {
                if (interceptorBeanClasses.contains(metadata.getValue())) continue;
                throw new DeploymentException(ValidatorMessage.INTERCEPTOR_NOT_ANNOTATED_OR_REGISTERED, metadata);
            }
        }
    }

    private void validateEnabledDecoratorClasses(BeanManagerImpl beanManager, BeanDeployment deployment) {
        BeansXml beansXml = deployment.getBeanDeploymentArchive().getBeansXml();
        if (beansXml != null && !beansXml.getEnabledDecorators().isEmpty()) {
            HashSet<String> decoratorBeanClasses = new HashSet<String>();
            for (Decorator<?> decorator : beanManager.getAccessibleDecorators()) {
                decoratorBeanClasses.add(decorator.getBeanClass().getName());
            }
            for (Metadata metadata : beansXml.getEnabledDecorators()) {
                if (decoratorBeanClasses.contains(metadata.getValue())) continue;
                throw new DeploymentException(ValidatorMessage.DECORATOR_CLASS_NOT_BEAN_CLASS_OF_DECORATOR, metadata, decoratorBeanClasses);
            }
        }
    }

    private void validateEnabledAlternativeStereotypes(BeanManagerImpl beanManager, BeanDeployment deployment) {
        BeansXml beansXml = deployment.getBeanDeploymentArchive().getBeansXml();
        if (beansXml != null && !beansXml.getEnabledAlternativeStereotypes().isEmpty()) {
            Map<String, Class<? extends Annotation>> loadedStereotypes = Types.buildClassNameMap(beanManager.getEnabled().getAlternativeStereotypes());
            for (Metadata<String> definition : beansXml.getEnabledAlternativeStereotypes()) {
                Class<? extends Annotation> stereotype = loadedStereotypes.get(definition.getValue());
                if (!beanManager.isStereotype(stereotype)) {
                    throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_NOT_STEREOTYPE, definition);
                }
                if (Validator.isAlternative(beanManager, stereotype)) continue;
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_NOT_ANNOTATED, definition);
            }
        }
    }

    private void validateEnabledAlternativeClasses(BeanManagerImpl beanManager, BeanDeployment deployment) {
        BeansXml beansXml = deployment.getBeanDeploymentArchive().getBeansXml();
        if (beansXml != null && !beansXml.getEnabledAlternativeClasses().isEmpty()) {
            Map<String, Class<?>> loadedClasses = Types.buildClassNameMap(beanManager.getEnabled().getAlternativeClasses());
            HashMultimap<Class<?>, Bean<?>> beansByClass = HashMultimap.create();
            for (Bean<?> bean : beanManager.getAccessibleBeans()) {
                if (bean instanceof NewBean) continue;
                beansByClass.put(bean.getBeanClass(), bean);
            }
            for (Metadata metadata : beansXml.getEnabledAlternativeClasses()) {
                Class<?> enabledClass = loadedClasses.get(metadata.getValue());
                if (enabledClass.isAnnotation() || enabledClass.isInterface()) {
                    throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_NOT_CLASS, metadata);
                }
                boolean alternativeBeanFound = false;
                for (Bean bean : beansByClass.get(enabledClass)) {
                    if (!bean.isAlternative()) continue;
                    alternativeBeanFound = true;
                }
                if (alternativeBeanFound) continue;
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_NOT_ANNOTATED, metadata);
            }
        }
    }

    private static boolean isAlternative(BeanManager beanManager, Class<? extends Annotation> stereotype) {
        for (Annotation annotation : beanManager.getStereotypeDefinition(stereotype)) {
            if (!annotation.annotationType().equals(Alternative.class)) continue;
            return true;
        }
        return false;
    }

    private void validateDisposalMethods(BeanDeployerEnvironment environment) {
        Set<DisposalMethod<?, ?>> beans = environment.getUnresolvedDisposalBeans();
        if (!beans.isEmpty()) {
            throw new DefinitionException(ValidatorMessage.DISPOSAL_METHODS_WITHOUT_PRODUCER, beans);
        }
    }

    protected void validateObserverMethods(Iterable<ObserverInitializationContext<?, ?>> observers, BeanManagerImpl beanManager) {
        for (ObserverInitializationContext<?, ?> omi : observers) {
            for (InjectionPoint injectionPoint : omi.getObserver().getInjectionPoints()) {
                this.validateInjectionPointForDefinitionErrors(injectionPoint, injectionPoint.getBean(), beanManager);
                this.validateMetadataInjectionPoint(injectionPoint, null, ValidatorMessage.INJECTION_INTO_NON_BEAN);
                this.validateInjectionPointForDeploymentProblems(injectionPoint, injectionPoint.getBean(), beanManager);
            }
        }
    }

    private static void checkFacadeInjectionPoint(InjectionPoint injectionPoint, Class<?> type) {
        ParameterizedType parameterizedType;
        Type injectionPointType = injectionPoint.getType();
        if (injectionPointType instanceof Class && type.equals(injectionPointType)) {
            throw new DefinitionException(ValidatorMessage.INJECTION_POINT_MUST_HAVE_TYPE_PARAMETER, type, injectionPoint);
        }
        if (injectionPointType instanceof ParameterizedType && !injectionPoint.isDelegate() && type.equals((parameterizedType = (ParameterizedType)injectionPointType).getRawType())) {
            if (parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable) {
                throw new DefinitionException(ValidatorMessage.INJECTION_POINT_WITH_TYPE_VARIABLE, injectionPoint);
            }
            if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
                throw new DefinitionException(ValidatorMessage.INJECTION_POINT_HAS_WILDCARD, type, injectionPoint);
            }
        }
    }

    public static void checkBeanMetadataInjectionPoint(Object bean, InjectionPoint ip, Type expectedTypeArgument) {
        if (!(ip.getType() instanceof ParameterizedType)) {
            throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE, ip.getType(), ip);
        }
        ParameterizedType parameterizedType = (ParameterizedType)ip.getType();
        if (parameterizedType.getActualTypeArguments().length != 1) {
            throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE, ip.getType(), ip);
        }
        Class rawType = (Class)parameterizedType.getRawType();
        Type typeArgument = parameterizedType.getActualTypeArguments()[0];
        if (bean == null) {
            throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_BEAN, ip);
        }
        if (rawType.equals(Interceptor.class) && !(bean instanceof Interceptor)) {
            throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE, ip.getType(), ip);
        }
        if (rawType.equals(Decorator.class) && !(bean instanceof Decorator)) {
            throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE, ip.getType(), ip);
        }
        Set<Annotation> qualifiers = ip.getQualifiers();
        if (qualifiers.contains(InterceptedLiteral.INSTANCE)) {
            if (!(bean instanceof Interceptor)) {
                throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_QUALIFIER, Intercepted.class, Interceptor.class, ip);
            }
            if (!rawType.equals(Bean.class)) {
                throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE, ip.getType(), ip);
            }
            if (!Reflections.isUnboundedWildcard(typeArgument)) {
                throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE_ARGUMENT, typeArgument, ip);
            }
        }
        if (qualifiers.contains(DecoratedLiteral.INSTANCE)) {
            if (!(bean instanceof Decorator)) {
                throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_QUALIFIER, Decorated.class, Decorator.class, ip);
            }
            Decorator decorator = (Decorator)Reflections.cast(bean);
            if (!rawType.equals(Bean.class)) {
                throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE, ip.getType(), ip);
            }
            if (!typeArgument.equals(decorator.getDelegateType())) {
                throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE_ARGUMENT, typeArgument, ip);
            }
        }
        if (qualifiers.contains(DefaultLiteral.INSTANCE) && !expectedTypeArgument.equals(typeArgument)) {
            throw new DefinitionException(ValidatorMessage.INVALID_BEAN_METADATA_INJECTION_POINT_TYPE_ARGUMENT, typeArgument, ip);
        }
    }

    private static boolean isInjectionPointSatisfied(InjectionPoint ij, Set<?> resolvedBeans, BeanManagerImpl beanManager) {
        if (ij.getBean() instanceof Decorator) {
            if (beanManager.getEnabled().isDecoratorEnabled(ij.getBean().getBeanClass())) {
                return resolvedBeans.size() > 0;
            }
            return true;
        }
        return resolvedBeans.size() > 0;
    }

    private static void validatePseudoScopedBean(Bean<?> bean, BeanManagerImpl beanManager) {
        Validator.reallyValidatePseudoScopedBean(bean, beanManager, new LinkedHashSet<Object>(), new HashSet());
    }

    private static void reallyValidatePseudoScopedBean(Bean<?> bean, BeanManagerImpl beanManager, Set<Object> dependencyPath, Set<Bean<?>> validatedBeans) {
        AbstractProducerBean producer;
        List<Decorator<?>> decorators;
        if (dependencyPath.contains(bean)) {
            ArrayList<Object> realDependencyPath = new ArrayList<Object>(dependencyPath);
            realDependencyPath.add(bean);
            throw new DeploymentException(ValidatorMessage.PSEUDO_SCOPED_BEAN_HAS_CIRCULAR_REFERENCES, realDependencyPath);
        }
        if (validatedBeans.contains(bean)) {
            return;
        }
        dependencyPath.add(bean);
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            if (injectionPoint.isDelegate()) continue;
            dependencyPath.add(injectionPoint);
            Validator.validatePseudoScopedInjectionPoint(injectionPoint, beanManager, dependencyPath, validatedBeans);
            dependencyPath.remove(injectionPoint);
        }
        if (bean instanceof DecorableBean && !(decorators = ((DecorableBean)Reflections.cast(bean)).getDecorators()).isEmpty()) {
            for (Decorator<?> decorator : decorators) {
                Validator.reallyValidatePseudoScopedBean(decorator, beanManager, dependencyPath, validatedBeans);
            }
        }
        if (bean instanceof AbstractProducerBean && !(bean instanceof EEResourceProducerField) && !beanManager.isNormalScope((producer = (AbstractProducerBean)bean).getDeclaringBean().getScope()) && !producer.getAnnotated().isStatic()) {
            Validator.reallyValidatePseudoScopedBean(producer.getDeclaringBean(), beanManager, dependencyPath, validatedBeans);
        }
        validatedBeans.add(bean);
        dependencyPath.remove(bean);
    }

    private static void validatePseudoScopedInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager, Set<Object> dependencyPath, Set<Bean<?>> validatedBeans) {
        boolean normalScoped;
        Set resolved = beanManager.getBeans(ij);
        Bean bean = beanManager.resolve(resolved);
        if (!(bean == null || bean instanceof AbstractBuiltInBean || ij.isDelegate() || (normalScoped = beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal()))) {
            Validator.reallyValidatePseudoScopedBean(bean, beanManager, dependencyPath, validatedBeans);
        }
    }

    @Override
    public void cleanup() {
    }
}

