/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class EnterpriseBeanProxyMethodHandler<T>
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 2107723373882153667L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final BeanManagerImpl manager;
    private final String beanId;
    private final SessionObjectReference reference;
    private final transient SessionBean<T> bean;

    public EnterpriseBeanProxyMethodHandler(SessionBean<T> bean) {
        this.bean = bean;
        this.manager = bean.getBeanManager();
        this.beanId = bean.getId();
        this.reference = bean.createReference();
        log.trace(BeanMessage.CREATED_SESSION_BEAN_PROXY, bean);
    }

    @Override
    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        if ("destroy".equals(method.getName()) && Marker.isMarker(0, method, args)) {
            if (this.bean.getEjbDescriptor().isStateful() && !this.reference.isRemoved()) {
                this.reference.remove();
            }
            return null;
        }
        if (!this.bean.isClientCanCallRemoveMethods() && this.isRemoveMethod(method)) {
            throw new UnsupportedOperationException(BeanMessage.INVALID_REMOVE_METHOD_INVOCATION, method);
        }
        Class<?> businessInterface = this.getBusinessInterface(method);
        if (this.reference.isRemoved() && this.isToStringMethod(method)) {
            return businessInterface.getName() + " [REMOVED]";
        }
        Object proxiedInstance = this.reference.getBusinessObject(businessInterface);
        Object returnValue = Reflections.invokeAndUnwrap(proxiedInstance, method, args);
        log.trace(BeanMessage.CALL_PROXIED_METHOD, method, proxiedInstance, args, returnValue);
        return returnValue;
    }

    private boolean isRemoveMethod(Method method) {
        MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
        return this.bean.getEjbDescriptor().getRemoveMethodSignatures().contains(methodSignature);
    }

    private boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    private Class<?> getBusinessInterface(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.equals(Object.class)) {
            return this.bean.getEjbDescriptor().getObjectInterface();
        }
        if (this.bean.getEjbDescriptor().getLocalBusinessInterfacesAsClasses().contains(declaringClass)) {
            return declaringClass;
        }
        Iterator<Class<?>> i$ = this.bean.getEjbDescriptor().getLocalBusinessInterfacesAsClasses().iterator();
        while (i$.hasNext()) {
            Class<?> view;
            for (Class<?> currentClass = view = i$.next(); currentClass != Object.class && currentClass != null; currentClass = currentClass.getSuperclass()) {
                if (!currentClass.equals(view)) continue;
                return view;
            }
        }
        throw new RuntimeException("Unable to locate a business interface declaring " + method);
    }

    private Object readResolve() throws ObjectStreamException {
        return new EnterpriseBeanProxyMethodHandler<T>((SessionBean)this.manager.getPassivationCapableBean(this.beanId));
    }
}

