/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.CreationException;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.exceptions.NullInstanceException;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface BeanLogger
extends WeldLogger {
    public static final BeanLogger LOG = Logger.getMessageLogger(BeanLogger.class, Category.BEAN.getName());

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1, value="Exactly one constructor ({0}) annotated with @Inject defined, using it as the bean constructor for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void foundOneInjectableConstructor(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=2, value="Exactly one constructor ({0}) defined, using it as the bean constructor for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void foundDefaultConstructor(Object var1, Object var2);

    @Deprecated
    @Message(id=3, value="Found {0} methods annotated with @PostConstruct for {1}", format=Message.Format.MESSAGE_FORMAT)
    public String foundPostConstructMethods(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=4, value="Exactly one post construct method ({0}) for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void foundOnePostConstructMethod(Object var1, Object var2);

    @Deprecated
    @Message(id=5, value="Found {0} methods annotated with @PreDestroy for {1}", format=Message.Format.MESSAGE_FORMAT)
    public String foundPreDestroyMethods(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=6, value="Exactly one pre destroy method ({0}) for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void foundOnePreDestroyMethod(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=7, value="Created session bean proxy for {0}", format=Message.Format.MESSAGE_FORMAT)
    public void createdSessionBeanProxy(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=8, value="Called {0} on {1} with parameters {2} which returned {3}", format=Message.Format.MESSAGE_FORMAT)
    public void callProxiedMethod(Object var1, Object var2, Object var3, Object var4);

    @Message(id=9, value="Dynamic lookup of {0} is not supported", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException dynamicLookupOfBuiltInNotAllowed(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=10, value="Using qualifiers {0} for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void qualifiersUsed(Object var1, Object var2);

    @Deprecated
    @Message(id=11, value="Adding @Default qualifier for {0}", format=Message.Format.MESSAGE_FORMAT)
    public String usingDefaultQualifier(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=12, value="Building bean metadata for {0}", format=Message.Format.MESSAGE_FORMAT)
    public void creatingBean(Object var1);

    @Deprecated
    @Message(id=13, value="Using default name {0} for {1}", format=Message.Format.MESSAGE_FORMAT)
    public String usingDefaultName(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=14, value="Using name {0} for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void usingName(Object var1, Object var2);

    @Deprecated
    @Message(id=15, value="Using scope {0} for {1} from merged stereotypes {2}", format=Message.Format.MESSAGE_FORMAT)
    public String usingScopeFromStereotype(Object var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=16, value="Using scope {0} for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void usingScope(Object var1, Object var2);

    @Deprecated
    @Message(id=17, value="Using default @Dependent scope for {0}", format=Message.Format.MESSAGE_FORMAT)
    public String usingDefaultScope(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="Executing producer field or method {0} on incomplete declaring bean {1} due to circular injection", format=Message.Format.MESSAGE_FORMAT)
    public void circularCall(Object var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=19, value="Error destroying an instance {0} of {1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorDestroying(Object var1, Object var2);

    @Deprecated
    @Message(id=20, value="Delegate injection point not found on decorator {0}", format=Message.Format.MESSAGE_FORMAT)
    public String delegateInjectionPointNotFound(Object var1);

    @Deprecated
    @Message(id=21, value="The annotation {0} is not a binding for {1}", format=Message.Format.MESSAGE_FORMAT)
    public String annotationNotBinding(Object var1, Object var2);

    @Deprecated
    @Message(id=22, value="The annotation {0} is already present in the bindings list for {1}", format=Message.Format.MESSAGE_FORMAT)
    public String duplicateBinding(Object var1, Object var2);

    @Message(id=23, value="Type parameter must be a concrete type:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public String typeParameterMustBeConcrete(Object var1);

    @Deprecated
    @Message(id=24, value="ValidationServices are not available")
    public String validationServiceNotAvailable();

    @Message(id=25, value="Tried to create an EEResourceProducerField, but no @Resource, @PersistenceContext, @PersistenceUnit, @WebServiceRef or @EJB is present {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException invalidResourceProducerField(Object var1);

    @Message(id=26, value="SecurityServices not available")
    public IllegalStateException securityServicesNotAvailable();

    @Message(id=27, value="TransactionServices not available")
    public IllegalStateException transactionServicesNotAvailable();

    @Message(id=28, value="Interception model must not be null")
    public IllegalArgumentException interceptionModelNull();

    @Message(id=29, value="InterceptionType must not be null")
    public IllegalArgumentException interceptionTypeNull();

    @Message(id=30, value="Method must not be null")
    public IllegalArgumentException methodNull();

    @Message(id=31, value="InterceptionType must not be lifecycle, but it is {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException interceptionTypeLifecycle(Object var1);

    @Message(id=32, value="InterceptionType must be lifecycle, but it is {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException interceptionTypeNotLifecycle(Object var1);

    @Message(id=33, value="Could not instantiate client proxy for {0}", format=Message.Format.MESSAGE_FORMAT)
    public String proxyInstantiationFailed(Object var1);

    @Message(id=34, value="Could not access bean correctly when creating client proxy for {0}", format=Message.Format.MESSAGE_FORMAT)
    public String proxyInstantiationBeanAccessFailed(Object var1);

    @Message(id=35, value="There was an error creating an id for {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException beanIdCreationFailed(Object var1);

    @Message(id=36, value="Unexpected unwrapped custom decorator instance: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unexpectedUnwrappedCustomDecorator(Object var1);

    @Message(id=37, value="Cannot call EJB remove method directly on non-dependent scoped bean {0}", format=Message.Format.MESSAGE_FORMAT)
    public UnsupportedOperationException invalidRemoveMethodInvocation(Object var1);

    @Message(id=38, value="Cannot place @Delegate at an injection point which is not on a Decorator: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException delegateNotOnDecorator(Object var1);

    @Message(id=39, value="@Typed class {0} is not present in the type hierarchy {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException typedClassNotInHierarchy(Object var1, Object var2);

    @Message(id=40, value="All stereotypes must specify the same scope OR a scope must be specified on {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException multipleScopesFoundFromStereotypes(Object var1);

    @Message(id=41, value="Cannot put name on specializing and specialized class {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException nameNotAllowedOnSpecialization(Object var1);

    @Message(id=42, value="Cannot operate on non container provided decorator {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException nonContainerDecorator(Object var1);

    @Message(id=43, value="The following bean is not an EE resource producer:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException beanNotEeResourceProducer(Object var1);

    @Message(id=44, value="Unable to obtain instance from {0}", format=Message.Format.MESSAGE_FORMAT)
    public NullInstanceException nullInstance(Object var1);

    @Message(id=45, value="Proxy required")
    public InvalidObjectException proxyRequired();

    @Message(id=46, value="At most one scope may be specified on {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException onlyOneScopeAllowed(Object var1);

    @Message(id=47, value="Specializing bean must extend another bean:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException specializingBeanMustExtendABean(Object var1);

    @Message(id=48, value="Conflicting interceptor bindings found on {0}", format=Message.Format.MESSAGE_FORMAT)
    public String conflictingInterceptorBindings(Object var1);

    @Message(id=49, value="Unable to invoke {0} on {1}", format=Message.Format.MESSAGE_FORMAT)
    public WeldException invocationError(Object var1, Object var2, @Cause Throwable var3);

    @Message(id=50, value="Cannot cast producer type {0} to bean type {1}", format=Message.Format.MESSAGE_FORMAT)
    public WeldException producerCastError(Object var1, Object var2, @Cause Throwable var3);

    @Message(id=51, value="Return type must be concrete:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException returnTypeMustBeConcrete(Object var1);

    @Message(id=52, value="Cannot return null from a non-dependent producer method:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalProductException nullNotAllowedFromProducer(Object var1);

    @Message(id=53, value="Producers cannot declare passivating scope and return a non-serializable class:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalProductException nonSerializableProductError(Object var1);

    @Message(id=54, value="Producers cannot produce non-serializable instances for injection into non-transient fields of passivating beans\n\nProducer:  {0}\nInjection Point:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalProductException nonSerializableFieldInjectionError(Object var1, Object var2);

    @Deprecated
    @Message(id=55, value="Producers cannot produce non-serializable instances for injection into parameters of initializers of beans declaring passivating scope.\n\nBean:  {0}\nInjection Point:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public String nonSerializableInitializerParamInjectionError(Object var1, Object var2);

    @Deprecated
    @Message(id=56, value="Producers cannot produce non-serializable instances for injection into parameters of producer methods declaring passivating scope.\n\nBean:  {0}\nInjection Point:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public String nonSerializableProducerParamInjectionError(Object var1, Object var2);

    @Deprecated
    @Message(id=57, value="Producers cannot produce non-serializable instances for injection into parameters of constructors of beans declaring passivating scope.\n\nBean:  {0}\nInjection Point:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public String nonSerializableConstructorParamInjectionError(Object var1, Object var2);

    @Message(id=58, value="Method with @Delegate parameter must be an initializer method:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException delegateOnNonInitializerMethod(Object var1);

    @Message(id=59, value="No delegate injection points defined for {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException noDelegateForDecorator(Object var1);

    @Message(id=60, value="Too many delegate injection points defined for {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException tooManyDelegatesForDecorator(Object var1);

    @Message(id=61, value="The delegate type must extend or implement every decorated type.  Decorated type {0} on {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException delegateMustSupportEveryDecoratedType(Object var1, Object var2);

    @Deprecated
    @Message(id=62, value="The decorated type is parameterized, but the delegate type isn't.  Delegate type {0} on {1}", format=Message.Format.MESSAGE_FORMAT)
    public String decoratedTypeParameterizedDelegateNot(Object var1, Object var2);

    @Deprecated
    @Message(id=63, value="The delegate type must have exactly the same type parameters as the decorated type.  Decorated type {0} on decorator {1}", format=Message.Format.MESSAGE_FORMAT)
    public String delegateTypeParameterMismatch(Object var1, Object var2);

    @Message(id=64, value="Unable to process {0}", format=Message.Format.MESSAGE_FORMAT)
    public String unableToProcess(Object var1);

    @Deprecated
    @Message(id=65, value="{0} does not have @Dispose as first parameter", format=Message.Format.MESSAGE_FORMAT)
    public String disposeNotFirstParam(Object var1);

    @Message(id=66, value="{0} has more than one @Dispose parameter", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException multipleDisposeParams(Object var1);

    @Message(id=67, value="{0} is not allowed on same method as {1}, see {2}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException inconsistentAnnotationsOnMethod(Object var1, Object var2, Object var3);

    @Message(id=68, value="Method {0} must be declared on a business interface of {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException methodNotBusinessMethod(Object var1, Object var2);

    @Message(id=69, value="An interceptor must have at least one binding, but {0} has none", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException missingBindingOnInterceptor(Object var1);

    @Message(id=70, value="Simple bean {0} cannot be a non-static inner class", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException simpleBeanAsNonStaticInnerClassNotAllowed(Object var1);

    @Message(id=71, value="Managed bean {0} must be @Dependent", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException beanMustBeDependent(Object var1);

    @Message(id=72, value="Bean declaring a passivating scope must be passivation capable.  Bean:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException passivatingBeanNeedsSerializableImpl(Object var1);

    @Message(id=73, value="Bean class which has decorators cannot be declared final:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException finalBeanClassWithDecoratorsNotAllowed(Object var1);

    @Deprecated
    @Message(id=74, value="Decorated bean method {0} (decorated by {1}) cannot be declared final", format=Message.Format.MESSAGE_FORMAT)
    public String finalDecoratedBeanMethodNotAllowed(Object var1, Object var2);

    @Message(id=75, value="Normal scoped managed bean implementation class has a public field:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException publicFieldOnNormalScopedBeanNotAllowed(Object var1);

    @Message(id=76, value="Managed bean constructor must not have a parameter annotated {0}:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException parameterAnnotationNotAllowedOnConstructor(Object var1, Object var2);

    @Message(id=77, value="Cannot declare multiple disposal methods for this producer method.\n\nProducer method:  {0}\nDisposal methods:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException multipleDisposalMethods(Object var1, Object var2);

    @Message(id=78, value="Specialized producer method does not override a method on the direct superclass:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException producerMethodNotSpecializing(Object var1);

    @Message(id=79, value="Could not find the EJB in JNDI:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public CreationException ejbNotFound(Object var1, @Cause Throwable var2);

    @Message(id=80, value="Enterprise beans cannot be interceptors:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException ejbCannotBeInterceptor(Object var1);

    @Message(id=81, value="Enterprise beans cannot be decorators:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException ejbCannotBeDecorator(Object var1);

    @Message(id=82, value="Scope {0} is not allowed on stateless enterprise beans for {1}.  Only @Dependent is allowed on stateless session beans.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException scopeNotAllowedOnStatelessSessionBean(Object var1, Object var2);

    @Message(id=83, value="Scope {0} is not allowed on singleton enterprise beans for {1}.  Only @Dependent and @ApplicationScoped is allowed on singleton session beans.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException scopeNotAllowedOnSingletonBean(Object var1, Object var2);

    @Message(id=84, value="Specializing enterprise bean must extend another enterprise bean:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException specializingEnterpriseBeanMustExtendAnEnterpriseBean(Object var1);

    @Message(id=85, value="Cannot destroy null instance of {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException cannotDestroyNullBean(Object var1);

    @Message(id=86, value="Cannot destroy session bean instance not created by the container:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException cannotDestroyEnterpriseBeanNotCreated(Object var1);

    @Message(id=87, value="Message driven beans cannot be Managed Beans:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException messageDrivenBeansCannotBeManaged(Object var1);

    @Message(id=88, value="Observer method must be static or local business method:  {0} on {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException observerMethodMustBeStaticOrBusiness(Object var1, Object var2);

    @Message(id=89, value="Unable to determine EJB for {0}, multiple EJBs with that class:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException tooManyEjbsForClass(Object var1, Object var2);

    @Message(id=90, value="Method {0} defined on {1} does not match any method on decorated types", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException abstractMethodMustMatchDecoratedType(Object var1, Object var2);

    @Deprecated
    @Message(id=91, value="Cannot handle injection point as a constructor or method:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public String ipNotConstructorOrMethod(Object var1);

    @Deprecated
    @Message(id=92, value="Parameter position {0} is not in the parameter list:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public String paramNotInParamList(Object var1, Object var2);

    @Deprecated
    @Message(id=93, value="Cannot read object")
    public String cannotReadObject();

    @Message(id=94, value="Injected field {0} cannot be annotated @Produces on {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectedFieldCannotBeProducer(Object var1, Object var2);

    @Message(id=95, value="Session bean with generic class {0} must be @Dependent scope", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException genericSessionBeanMustBeDependent(Object var1);

    @Message(id=96, value="Producer fields on session beans must be static. Field {0} declared on {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException producerFieldOnSessionBeanMustBeStatic(Object var1, Object var2);

    @Message(id=97, value="A producer method with a parameterized return type with a type variable must be declared @Dependent scoped. Method {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException producerMethodWithTypeVariableReturnTypeMustBeDependent(Object var1);

    @Message(id=98, value="A producer method cannot have a return type parameterized with wildcards. Method {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException producerMethodCannotHaveAWildcardReturnType(Object var1);

    @Message(id=99, value="Cannot load class {0} during deserialization of proxy", format=Message.Format.MESSAGE_FORMAT)
    public WeldException cannotLoadClass(Object var1, @Cause Throwable var2);

    @Message(id=1500, value="Failed to deserialize proxy object")
    public WeldException proxyDeserializationFailure();

    @Message(id=1501, value="Method call requires a BeanInstance which has not been set for this proxy {0}", format=Message.Format.MESSAGE_FORMAT)
    public WeldException beanInstanceNotSetOnProxy(Object var1);

    @Message(id=1502, value="Resource producer field [{0}] must be @Dependent scoped", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException nonDependentResourceProducerField(Object var1);

    @Message(id=1503, value="Bean class which has interceptors cannot be declared final:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException finalBeanClassWithInterceptorsNotAllowed(Object var1);

    @Message(id=1504, value="Intercepted bean method {0} (intercepted by {1}) cannot be declared final", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException finalInterceptedBeanMethodNotAllowed(Object var1, Object var2);

    @Deprecated
    @Message(id=1505, value="Failed to set ThreadLocal for serialization on proxy using reflection {0}", format=Message.Format.MESSAGE_FORMAT)
    public String failedToSetThreadLocalOnProxy(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1506, value="Created new client proxy of type {0} for bean {1} with ID {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createdNewClientProxyType(Object var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1507, value="Located client proxy of type {0} for bean {1}", format=Message.Format.MESSAGE_FORMAT)
    public void lookedUpClientProxy(Object var1, Object var2);

    @Message(id=1508, value="Cannot create an InjectionTarget from {0} as it is an interface", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionTargetCannotBeCreatedForInterface(Object var1);

    @Message(id=1510, value="Non passivation capable bean serialized with ProxyMethodHandler")
    public WeldException proxyHandlerSerializedForNonSerializableBean();

    @Message(id=1511, value="Specializing bean {0} does not have bean type {1} of specialized bean {2}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException specializingBeanMissingSpecializedType(Object var1, Object var2, Object var3);

    @Message(id=1512, value="{0} cannot be constructed for {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidInjectionPointType(Object var1, Object var2);

    @Message(id=1513, value="An implementation of AnnotatedCallable must implement either AnnotatedConstructor or AnnotatedMethod, {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidAnnotatedCallable(Object var1);

    @Message(id=1514, value="An implementation of AnnotatedMember must implement either AnnotatedConstructor, AnnotatedMethod or AnnotatedField, {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidAnnotatedMember(Object var1);

    @Message(id=1515, value="Unable to load annotated member {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToLoadMember(Object var1);

    @Message(id=1516, value="Resource producer field [{0}] must not have an EL name", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException namedResourceProducerField(Object var1);

    @Message(id=1517, value="The type of the resource producer field [{0}] does not match the resource type {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidResourceProducerType(Object var1, Object var2);

    @Message(id=1518, value="Cannot create Producer implementation. Declaring bean missing for a non-static member {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException declaringBeanMissing(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1519, value="An InjectionTarget is created for an abstract {0}. It will not be possible to produce instances of this type!", format=Message.Format.MESSAGE_FORMAT)
    public void injectionTargetCreatedForAbstractClass(Object var1);

    @Message(id=1520, value="Beans with different bean names {0}, {1} cannot be specialized by a single bean {2}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException beansWithDifferentBeanNamesCannotBeSpecialized(Object var1, Object var2, Object var3);

    @Message(id=1521, value="InjectionPoint.getAnnotated() must return either AnnotatedParameter or AnnotatedField but {0} was returned for {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidAnnotatedOfInjectionPoint(Object var1, Object var2);

    @Message(id=1522, value="Unable to restore InjectionPoint. No matching InjectionPoint found on {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToRestoreInjectionPoint(Object var1);

    @Message(id=1523, value="Unable to restore InjectionPoint. Multiple matching InjectionPoints found on {0}:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToRestoreInjectionPointMultiple(Object var1, Object var2, Object var3);

    @Message(id=1524, value="Unable to load proxy class for bean {0} with class {1} using classloader {2}", format=Message.Format.MESSAGE_FORMAT)
    public WeldException unableToLoadProxyClass(Object var1, Object var2, Object var3, @Cause Throwable var4);

    @Message(id=1525, value="Instance.destroy() is not supported. The underlying context {0} does not support destroying of contextual instances", format=Message.Format.MESSAGE_FORMAT)
    public UnsupportedOperationException destroyUnsupported(Object var1);

    @Message(id=1526, value="Managed bean declaring a passivating scope has a non-passivation capable decorator.  Bean:  {0}  Decorator: {1}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException passivatingBeanHasNonPassivationCapableDecorator(Object var1, Object var2);

    @Message(id=1527, value="Managed bean declaring a passivating scope has a non-serializable interceptor.  Bean:  {0}  Interceptor: {1}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException passivatingBeanHasNonPassivationCapableInterceptor(Object var1, Object var2);

    @Deprecated
    @Message(id=1528, value="Unable to create a new instance of {0}", format=Message.Format.MESSAGE_FORMAT)
    public String cannotInstantiateAbstractClass(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1529, value="An InjectionTarget is created for a {0} which does not have any appropriate constructor.", format=Message.Format.MESSAGE_FORMAT)
    public void injectionTargetCreatedForClassWithoutAppropriateConstructor(Object var1);

    @Message(id=1530, value="Cannot produce an instance of {0}.", format=Message.Format.MESSAGE_FORMAT)
    public CreationException injectionTargetCannotProduceInstance(Object var1);

    @Message(id=1531, value="Instance.iterator().remove() is not supported.")
    public UnsupportedOperationException instanceIteratorRemoveUnsupported();

    @Message(id=1532, value="A passivation capable bean cannot have a null id: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException passivationCapableBeanHasNullId(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1533, value="An InjectionTarget is created for a non-static inner {0}. It will not be possible to produce instances of this type!", format=Message.Format.MESSAGE_FORMAT)
    public void injectionTargetCreatedForNonStaticInnerClass(Object var1);

    @Message(id=1534, value="Bean class which has decorators must have a public constructor without parameters: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException decoratedHasNoNoargsConstructor(Object var1);

    @Message(id=1535, value="Constructor without parameters cannot be private in bean class which has decorators: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException decoratedNoargsConstructorIsPrivate(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1536, value="Found {0} constructors annotated with @Inject for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void foundInjectableConstructors(Object var1, Object var2);

    @Message(id=1537, value="An InjectionTarget is created for a {0} which does not have any appropriate constructor.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionTargetCreatedForClassWithoutAppropriateConstructorException(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1538, value="Created context instance for bean {0} identified as {1}", format=Message.Format.MESSAGE_FORMAT)
    public void createdContextInstance(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1539, value="Created MH initializer body for decorator proxy: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void createdMethodHandlerInitializerForDecoratorProxy(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1540, value="Adding method to enterprise proxy: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void addingMethodToEnterpriseProxy(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1541, value="Adding method to proxy: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void addingMethodToProxy(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1542, value="Retrieving/generating proxy class {0}", format=Message.Format.MESSAGE_FORMAT)
    public void generatingProxyClass(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1543, value="Created Proxy class of type {0} supporting interfaces {1}", format=Message.Format.MESSAGE_FORMAT)
    public void createdProxyClass(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1544, value="MethodHandler processing returning bean instance for {0}", format=Message.Format.MESSAGE_FORMAT)
    public void methodHandlerProcessingReturningBeanInstance(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1545, value="MethodHandler processing call to {0} for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void methodHandlerProcessingCall(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1546, value="Setting new MethodHandler with bean instance for {0} on {1}", format=Message.Format.MESSAGE_FORMAT)
    public void settingNewMethodHandler(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1547, value="Invoking interceptor chain for method {0} on {1}", format=Message.Format.MESSAGE_FORMAT)
    public void invokingInterceptorChain(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1548, value="Invoking method {0} directly on {1}", format=Message.Format.MESSAGE_FORMAT)
    public void invokingMethodDirectly(Object var1, Object var2);

    @Message(id=1549, value="Unable to determine parent creational context of {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unableToDetermineParentCreationalContext(Object var1);

    @Message(id=1550, value="A producer field with a parameterized type with a type variable must be declared @Dependent scoped. Field {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException producerFieldWithTypeVariableBeanTypeMustBeDependent(Object var1);

    @Message(id=1551, value="A producer field's type cannot be a parameterized type with wildcards. Field {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException producerFieldCannotHaveAWildcardBeanType(Object var1);
}

