/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.servlet;

import javax.servlet.ServletContext;
import org.jboss.weld.logging.ServletLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.spi.HttpContextActivationFilter;
import org.jboss.weld.servlet.spi.helpers.AcceptingHttpContextActivationFilter;
import org.jboss.weld.servlet.spi.helpers.RegexHttpContextActivationFilter;

public class ServletUtils {
    public static final String CONTEXT_MAPPING = "org.jboss.weld.context.mapping";

    private ServletUtils() {
    }

    public static HttpContextActivationFilter getContextActivationFilter(BeanManagerImpl manager, ServletContext context) {
        HttpContextActivationFilter filter = manager.getServices().get(HttpContextActivationFilter.class);
        String pattern = context.getInitParameter(CONTEXT_MAPPING);
        if (filter == AcceptingHttpContextActivationFilter.INSTANCE) {
            if (pattern != null) {
                return new RegexHttpContextActivationFilter(pattern);
            }
        } else if (pattern != null) {
            ServletLogger.LOG.webXmlMappingPatternIgnored(pattern);
        }
        return filter;
    }
}

