/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.jboss.weld.interceptor.reader.AnnotatedMethodReader;
import org.jboss.weld.interceptor.reader.ReflectiveAnnotatedMethodReader;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.util.collections.ArraySet;

public class DefaultMethodMetadata<M>
implements MethodMetadata {
    private final Method javaMethod;
    private final Set<InterceptionType> supportedInterceptorTypes;

    private DefaultMethodMetadata(M methodReference, AnnotatedMethodReader<M> annotationReader) {
        this.javaMethod = annotationReader.getJavaMethod(methodReference);
        ArraySet<InterceptionType> supportedInterceptorTypes = new ArraySet<InterceptionType>();
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (annotationReader.getAnnotation(InterceptionTypeRegistry.getAnnotationClass(interceptionType), methodReference) == null) continue;
            supportedInterceptorTypes.add(interceptionType);
        }
        this.supportedInterceptorTypes = supportedInterceptorTypes.isEmpty() ? Collections.emptySet() : supportedInterceptorTypes;
    }

    public static <M> MethodMetadata of(M methodReference, AnnotatedMethodReader<M> methodReader) {
        return new DefaultMethodMetadata<M>(methodReference, methodReader);
    }

    public static MethodMetadata of(Method method) {
        return new DefaultMethodMetadata<Method>(method, ReflectiveAnnotatedMethodReader.getInstance());
    }

    @Override
    public boolean isInterceptorMethod() {
        return !this.supportedInterceptorTypes.isEmpty();
    }

    @Override
    public Set<InterceptionType> getSupportedInterceptionTypes() {
        return this.supportedInterceptorTypes;
    }

    @Override
    public Method getJavaMethod() {
        return this.javaMethod;
    }

    @Override
    public Class<?> getReturnType() {
        return this.javaMethod.getReturnType();
    }
}

