/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collections;
import java.util.Set;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.bootstrap.AnnotatedTypeLoader;
import org.jboss.weld.bootstrap.FastProcessAnnotatedTypeResolver;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.resources.spi.ClassFileInfoException;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Beans;

public class FastAnnotatedTypeLoader
extends AnnotatedTypeLoader {
    private final ClassFileServices classFileServices;
    private final FastProcessAnnotatedTypeResolver resolver;

    public FastAnnotatedTypeLoader(BeanManagerImpl manager, ClassTransformer transformer, ClassFileServices classFileServices, ContainerLifecycleEvents events, FastProcessAnnotatedTypeResolver resolver) {
        super(manager, transformer, events);
        this.classFileServices = classFileServices;
        this.resolver = resolver;
    }

    @Override
    public <T> SlimAnnotatedTypeContext<T> loadAnnotatedType(String className, String bdaId) {
        try {
            ClassFileInfo classFileInfo = this.classFileServices.getClassFileInfo(className);
            if ((classFileInfo.getModifiers() & 0x2000) != 0) {
                return null;
            }
            if (classFileInfo.isVetoed()) {
                return null;
            }
            Set<Object> observerMethods = Collections.emptySet();
            if (this.containerLifecycleEvents.isProcessAnnotatedTypeObserved() && !(observerMethods = this.resolver.resolveProcessAnnotatedTypeObservers(className)).isEmpty()) {
                return this.createContext(className, classFileInfo, observerMethods, bdaId);
            }
            if (Beans.isTypeManagedBeanOrDecoratorOrInterceptor(classFileInfo)) {
                return this.createContext(className, classFileInfo, observerMethods, bdaId);
            }
            return null;
        }
        catch (ClassFileInfoException e) {
            BootstrapLogger.LOG.exceptionLoadingAnnotatedType(e.getMessage());
            return super.loadAnnotatedType(className, bdaId);
        }
    }

    private <T> SlimAnnotatedTypeContext<T> createContext(String className, ClassFileInfo classFileInfo, Set<ExtensionObserverMethodImpl<?, ?>> observerMethods, String bdaId) {
        SlimAnnotatedType type = this.loadAnnotatedType(this.loadClass(className), bdaId);
        if (type != null) {
            return SlimAnnotatedTypeContext.of(type, classFileInfo, observerMethods, this.classTransformer);
        }
        return null;
    }

    @Override
    protected <T> SlimAnnotatedType<T> loadAnnotatedType(Class<T> clazz, String bdaId) {
        if (clazz != null) {
            try {
                return this.classTransformer.getBackedAnnotatedType(clazz, bdaId);
            }
            catch (ResourceLoadingException e) {
                this.missingDependenciesRegistry.handleResourceLoadingException(clazz.getName(), e);
            }
        }
        return null;
    }
}

