/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.servlet.WeldServletLifecycle;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;

public class EnhancedListener
extends ForwardingServletListener
implements ServletContainerInitializer {
    private static final Logger log = Logger.getLogger(EnhancedListener.class);
    private boolean isOriginalListenerUsed = false;
    private WeldServletLifecycle lifecycle;

    public void onStartup(Set<Class<?>> classes, ServletContext context) throws ServletException {
        log.info("Initialize Weld using ServletContainerInitializer");
        this.lifecycle = new WeldServletLifecycle();
        this.lifecycle.initialize(context);
        context.setAttribute(WeldServletLifecycle.INSTANCE_ATTRIBUTE_NAME, (Object)this.lifecycle);
        context.setAttribute(WeldServletLifecycle.LISTENER_CLASS_FLAG_ATTRIBUTE_NAME, (Object)this.getClass().getName());
        context.addListener((EventListener)((Object)this));
        super.contextInitialized(new ServletContextEvent(context));
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        if (sce.getServletContext().getAttribute(WeldServletLifecycle.LISTENER_CLASS_FLAG_ATTRIBUTE_NAME).equals(Listener.class.getName())) {
            this.isOriginalListenerUsed = true;
            log.info("org.jboss.weld.environment.servlet.Listener used for ServletRequest and HttpSession notifications");
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.lifecycle.destroy(sce.getServletContext());
        super.contextDestroyed(sce);
    }

    @Override
    public void requestDestroyed(ServletRequestEvent sre) {
        if (this.isOriginalListenerUsed) {
            return;
        }
        super.requestDestroyed(sre);
    }

    @Override
    public void requestInitialized(ServletRequestEvent sre) {
        if (this.isOriginalListenerUsed) {
            return;
        }
        super.requestInitialized(sre);
    }

    @Override
    public void sessionCreated(HttpSessionEvent se) {
        if (this.isOriginalListenerUsed) {
            return;
        }
        super.sessionCreated(se);
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.isOriginalListenerUsed) {
            return;
        }
        super.sessionDestroyed(se);
    }

    @Override
    protected ServletListener delegate() {
        return this.lifecycle.getWeldListener();
    }
}

