/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.tomcat;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.AnnotationProcessor;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.StandardContext;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.tomcat.ForwardingAnnotationProcessor;
import org.jboss.weld.environment.tomcat.WeldAnnotationProcessor;
import org.jboss.weld.manager.api.WeldManager;

public class WeldForwardingAnnotationProcessor
extends ForwardingAnnotationProcessor {
    private static final String NEITHER_FIELD_NOR_SETTER_FOUND_FOR_ANNOTATION_PROCESSOR = "neither field nor setter found for annotationProcessor";
    private static final String ANNOTATION_PROCESSOR_FIELD_NAME = "annotationProcessor";
    private final AnnotationProcessor firstProcessor;
    private final AnnotationProcessor secondProcessor;

    public WeldForwardingAnnotationProcessor(AnnotationProcessor originalAnnotationProcessor, AnnotationProcessor weldProcessor) {
        this.firstProcessor = originalAnnotationProcessor;
        this.secondProcessor = weldProcessor;
    }

    @Override
    protected AnnotationProcessor delegate() {
        return this.firstProcessor;
    }

    @Override
    public void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        super.processAnnotations(instance);
        this.secondProcessor.processAnnotations(instance);
    }

    @Override
    public void postConstruct(Object instance) throws IllegalAccessException, InvocationTargetException {
        super.postConstruct(instance);
        this.secondProcessor.postConstruct(instance);
    }

    @Override
    public void preDestroy(Object instance) throws IllegalAccessException, InvocationTargetException {
        super.preDestroy(instance);
        this.secondProcessor.preDestroy(instance);
    }

    public static void replaceAnnotationProcessor(ServletContext context, WeldManager manager) {
        StandardContext stdContext = WeldForwardingAnnotationProcessor.getStandardContext(context);
        WeldForwardingAnnotationProcessor.setAnnotationProcessor(stdContext, WeldForwardingAnnotationProcessor.createInstance(manager, stdContext));
    }

    private static WeldForwardingAnnotationProcessor createInstance(WeldManager manager, StandardContext stdContext) {
        try {
            Class clazz = Reflections.classForName(WeldAnnotationProcessor.class.getName());
            AnnotationProcessor weldProcessor = (AnnotationProcessor)clazz.getConstructor(WeldManager.class).newInstance(manager);
            return new WeldForwardingAnnotationProcessor(WeldForwardingAnnotationProcessor.getAnnotationProcessor(stdContext), weldProcessor);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create WeldForwardingAnnotationProcessor", e);
        }
    }

    private static StandardContext getStandardContext(ServletContext context) {
        try {
            ApplicationContext appContext = (ApplicationContext)WeldForwardingAnnotationProcessor.getContextFieldValue((ApplicationContextFacade)context, ApplicationContextFacade.class);
            return (StandardContext)WeldForwardingAnnotationProcessor.getContextFieldValue(appContext, ApplicationContext.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get StandardContext from ServletContext", e);
        }
    }

    private static <E> Object getContextFieldValue(E obj, Class<E> clazz) throws NoSuchFieldException, IllegalAccessException {
        Field f = clazz.getDeclaredField("context");
        f.setAccessible(true);
        return f.get(obj);
    }

    public static void restoreAnnotationProcessor(ServletContext context) {
        StandardContext stdContext = WeldForwardingAnnotationProcessor.getStandardContext(context);
        AnnotationProcessor ap = WeldForwardingAnnotationProcessor.getAnnotationProcessor(stdContext);
        if (ap instanceof WeldForwardingAnnotationProcessor) {
            WeldForwardingAnnotationProcessor.setAnnotationProcessor(stdContext, ((WeldForwardingAnnotationProcessor)ap).firstProcessor);
        }
    }

    private static AnnotationProcessor getAnnotationProcessor(StandardContext stdContext) {
        Method method = Reflections.findDeclaredMethod(stdContext.getClass(), "getAnnotationProcessor", new Class[0]);
        if (method != null) {
            return Reflections.invokeMethod(method, AnnotationProcessor.class, stdContext, new Object[0]);
        }
        Field field = Reflections.findDeclaredField(stdContext.getClass(), ANNOTATION_PROCESSOR_FIELD_NAME);
        if (field != null) {
            return Reflections.getFieldValue(field, stdContext, AnnotationProcessor.class);
        }
        throw new RuntimeException(NEITHER_FIELD_NOR_SETTER_FOUND_FOR_ANNOTATION_PROCESSOR);
    }

    private static void setAnnotationProcessor(StandardContext stdContext, AnnotationProcessor annotationProcessor) {
        Method method = Reflections.findDeclaredMethod(stdContext.getClass(), "setAnnotationProcessor", AnnotationProcessor.class);
        if (method != null) {
            Reflections.invokeMethod(method, Void.TYPE, stdContext, annotationProcessor);
            return;
        }
        Field field = Reflections.findDeclaredField(stdContext.getClass(), ANNOTATION_PROCESSOR_FIELD_NAME);
        if (field != null) {
            Reflections.setFieldValue(field, stdContext, annotationProcessor);
            return;
        }
        throw new RuntimeException(NEITHER_FIELD_NOR_SETTER_FOUND_FOR_ANNOTATION_PROCESSOR);
    }
}

