/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.chain;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.context.InterceptionChain;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.InterceptorLogger;

public abstract class AbstractInterceptionChain
implements InterceptionChain {
    private int currentPosition = 0;
    private final List<InterceptorMethodInvocation> interceptorMethodInvocations;

    private static List<InterceptorMethodInvocation> buildInterceptorMethodInvocations(Object instance, Method method, Object[] args, InterceptionType interceptionType, InterceptionContext ctx) {
        List<InterceptorClassMetadata<?>> interceptorList = ctx.getInterceptionModel().getInterceptors(interceptionType, method);
        ArrayList<InterceptorMethodInvocation> interceptorInvocations = new ArrayList<InterceptorMethodInvocation>(interceptorList.size());
        for (InterceptorClassMetadata<?> interceptorMetadata : interceptorList) {
            interceptorInvocations.addAll(interceptorMetadata.getInterceptorInvocation(ctx.getInterceptorInstance(interceptorMetadata), interceptionType).getInterceptorMethodInvocations());
        }
        TargetClassInterceptorMetadata targetClassInterceptorMetadata = ctx.getInterceptionModel().getTargetClassInterceptorMetadata();
        if (targetClassInterceptorMetadata != null && targetClassInterceptorMetadata.isEligible(interceptionType)) {
            interceptorInvocations.addAll(targetClassInterceptorMetadata.getInterceptorInvocation(instance, interceptionType).getInterceptorMethodInvocations());
        }
        return interceptorInvocations;
    }

    private static List<InterceptorMethodInvocation> buildInterceptorMethodInvocations(List<InterceptorClassMetadata<?>> interceptorMetadata, InterceptionContext ctx, InterceptionType interceptionType) {
        ArrayList<InterceptorMethodInvocation> interceptorInvocations = new ArrayList<InterceptorMethodInvocation>(interceptorMetadata.size());
        for (InterceptorClassMetadata<?> metadata : interceptorMetadata) {
            Object interceptorInstance = ctx.getInterceptorInstance(metadata);
            InterceptorInvocation invocation = metadata.getInterceptorInvocation(interceptorInstance, interceptionType);
            interceptorInvocations.addAll(invocation.getInterceptorMethodInvocations());
        }
        return interceptorInvocations;
    }

    protected AbstractInterceptionChain(Object instance, Method method, Object[] args, InterceptionType interceptionType, InterceptionContext ctx) {
        this(AbstractInterceptionChain.buildInterceptorMethodInvocations(instance, method, args, interceptionType, ctx));
    }

    protected AbstractInterceptionChain(List<InterceptorClassMetadata<?>> interceptorMetadata, InterceptionContext ctx, InterceptionType interceptionType) {
        this(AbstractInterceptionChain.buildInterceptorMethodInvocations(interceptorMetadata, ctx, interceptionType));
    }

    protected AbstractInterceptionChain(InterceptorInvocation interceptorInvocation) {
        this(new ArrayList<InterceptorMethodInvocation>(interceptorInvocation.getInterceptorMethodInvocations()));
    }

    private AbstractInterceptionChain(List<InterceptorMethodInvocation> interceptorMethodInvocations) {
        this.interceptorMethodInvocations = interceptorMethodInvocations;
    }

    @Override
    public Object invokeNextInterceptor(InvocationContext invocationContext) throws Exception {
        try {
            if (this.hasNextInterceptor()) {
                return this.invokeNext(invocationContext);
            }
            return this.interceptorChainCompleted(invocationContext);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeNext(InvocationContext invocationContext) throws Exception {
        int oldCurrentPosition = this.currentPosition;
        try {
            InterceptorMethodInvocation nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
            InterceptorLogger.LOG.invokingNextInterceptorInChain(nextInterceptorMethodInvocation.toString());
            if (nextInterceptorMethodInvocation.expectsInvocationContext()) {
                Object object = nextInterceptorMethodInvocation.invoke(invocationContext);
                return object;
            }
            nextInterceptorMethodInvocation.invoke(null);
            while (this.hasNextInterceptor()) {
                nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
                nextInterceptorMethodInvocation.invoke(null);
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.currentPosition = oldCurrentPosition;
        }
    }

    protected abstract Object interceptorChainCompleted(InvocationContext var1) throws Exception;

    @Override
    public boolean hasNextInterceptor() {
        return this.currentPosition < this.interceptorMethodInvocations.size();
    }
}

