/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

class SimpleInterceptorInvocation
implements InterceptorInvocation {
    private final List<InterceptorMethodInvocation> interceptorMethodInvocations;
    private final Object instance;
    private final boolean targetClass;
    private final InterceptionType interceptionType;

    public SimpleInterceptorInvocation(Object instance, InterceptionType interceptionType, Collection<Method> interceptorMethods, boolean targetClass) {
        this.instance = instance;
        this.interceptionType = interceptionType;
        this.targetClass = targetClass;
        this.interceptorMethodInvocations = new ArrayList<InterceptorMethodInvocation>();
        for (Method method : interceptorMethods) {
            this.interceptorMethodInvocations.add(new SimpleMethodInvocation(method));
        }
    }

    @Override
    public List<InterceptorMethodInvocation> getInterceptorMethodInvocations() {
        return this.interceptorMethodInvocations;
    }

    class SimpleMethodInvocation
    implements InterceptorMethodInvocation {
        private final Method method;

        SimpleMethodInvocation(Method method) {
            this.method = method;
        }

        @Override
        public Object invoke(InvocationContext invocationContext) throws Exception {
            if (invocationContext != null) {
                return this.method.invoke(SimpleInterceptorInvocation.this.instance, invocationContext);
            }
            return this.method.invoke(SimpleInterceptorInvocation.this.instance, new Object[0]);
        }

        @Override
        public boolean expectsInvocationContext() {
            return !SimpleInterceptorInvocation.this.targetClass || !SimpleInterceptorInvocation.this.interceptionType.isLifecycleCallback();
        }
    }
}

