/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Named;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.security.SetAccessibleAction;

public class QualifierInstance {
    public static final QualifierInstance ANY = new QualifierInstance(Any.class);
    private final Class<? extends Annotation> annotationClass;
    private final Map<AnnotatedMethod<?>, Object> values;
    private final int hashCode;

    public static QualifierInstance of(Annotation annotation, MetaAnnotationStore store) {
        return QualifierInstance.getValue(annotation, store, true);
    }

    public static QualifierInstance of(Annotation annotation, MetaAnnotationStore store, boolean useQualifierInstanceCache) {
        return QualifierInstance.getValue(annotation, store, useQualifierInstanceCache);
    }

    public static Set<QualifierInstance> qualifiers(BeanManagerImpl beanManager, Set<Annotation> annotations) {
        return QualifierInstance.qualifiers(beanManager.getServices().get(MetaAnnotationStore.class), beanManager.getServices().get(SharedObjectCache.class), annotations);
    }

    public static Set<QualifierInstance> qualifiers(MetaAnnotationStore store, SharedObjectCache sharedObjectCache, Set<Annotation> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        boolean useSharedCache = sharedObjectCache != null;
        for (Annotation annotation : annotations) {
            boolean useQualifierInstanceCache = QualifierInstance.useQualifierInstanceCache(annotation);
            if (!useQualifierInstanceCache) {
                useSharedCache = false;
            }
            builder.add(QualifierInstance.getValue(annotation, store, useQualifierInstanceCache));
        }
        return useSharedCache ? sharedObjectCache.getSharedSet(builder.build()) : builder.build();
    }

    public static Set<QualifierInstance> qualifiers(BeanManagerImpl beanManager, Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).getQualifierInstances();
        }
        return QualifierInstance.qualifiers(beanManager, bean.getQualifiers());
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass) {
        this(annotationClass, Collections.emptyMap());
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass, Map<AnnotatedMethod<?>, Object> values) {
        this.annotationClass = annotationClass;
        this.values = values;
        this.hashCode = Objects.hashCode(annotationClass, values);
    }

    private static Map<AnnotatedMethod<?>, Object> createValues(Annotation instance, MetaAnnotationStore store) {
        Class<? extends Annotation> annotationClass = instance.annotationType();
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(annotationClass);
        if (model.getAnnotatedAnnotation().getMethods().size() == 0) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AnnotatedMethod method : model.getAnnotatedAnnotation().getMethods()) {
            if (model.getNonBindingMembers().contains(method)) continue;
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(SetAccessibleAction.of(method.getJavaMember()));
                } else {
                    method.getJavaMember().setAccessible(true);
                }
                builder.put(method, method.getJavaMember().invoke((Object)instance, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new WeldException(e);
            }
            catch (InvocationTargetException e) {
                throw new WeldException(e);
            }
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifierInstance that = (QualifierInstance)o;
        if (!this.annotationClass.equals(that.annotationClass)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "QualifierInstance{annotationClass=" + this.annotationClass + ", values=" + this.values + ", hashCode=" + this.hashCode + '}';
    }

    private static QualifierInstance getValue(Annotation annotation, MetaAnnotationStore store, boolean useQualifierInstanceCache) {
        return useQualifierInstanceCache ? store.getCachedQualifierInstance(annotation) : new QualifierInstance(annotation.annotationType(), QualifierInstance.createValues(annotation, store));
    }

    private static boolean useQualifierInstanceCache(Annotation annotation) {
        if (annotation.annotationType().equals(Named.class)) {
            Named named = (Named)annotation;
            return named.value().equals("");
        }
        return true;
    }
}

