/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.reflect.Type;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.Container;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.logging.ServletLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.ConversationFilter;
import org.jboss.weld.servlet.HttpContextLifecycle;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;
import org.jboss.weld.servlet.spi.HttpContextActivationFilter;
import org.jboss.weld.util.servlet.ServletUtils;

public class WeldInitialListener
extends AbstractServletListener {
    private static final String LAZY_CONVERSATION_CONTEXT_PARAM = "org.jboss.weld.context.conversation.lazy";
    @Inject
    private BeanManagerImpl beanManager;
    private HttpContextLifecycle lifecycle;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        Container instance;
        String contextId;
        ServletContext ctx = sce.getServletContext();
        if (this.beanManager == null && (contextId = ctx.getInitParameter("WELD_CONTEXT_ID_KEY")) != null && (instance = Container.instance(contextId)).beanDeploymentArchives().size() == 1) {
            this.beanManager = instance.beanDeploymentArchives().values().iterator().next();
        }
        if (this.beanManager == null) {
            this.beanManager = BeanManagerProxy.unwrap(CDI.current().getBeanManager());
        }
        HttpContextActivationFilter filter = ServletUtils.getContextActivationFilter(this.beanManager, ctx);
        boolean ignoreForwards = this.getBooleanInitParameter(ctx, "org.jboss.weld.context.ignore.forward", true);
        boolean ignoreIncludes = this.getBooleanInitParameter(ctx, "org.jboss.weld.context.ignore.include", true);
        boolean lazyConversationContext = this.initLazyConversationContext(this.beanManager, ctx);
        this.lifecycle = new HttpContextLifecycle(this.beanManager, filter, ignoreForwards, ignoreIncludes, lazyConversationContext);
        if (Boolean.valueOf(ctx.getInitParameter(ConversationFilter.CONVERSATION_FILTER_REGISTERED)).booleanValue()) {
            this.lifecycle.setConversationActivationEnabled(false);
        }
        this.lifecycle.contextInitialized(ctx);
    }

    private boolean getBooleanInitParameter(ServletContext ctx, String parameterName, boolean defaultValue) {
        String value = ctx.getInitParameter(parameterName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private boolean initLazyConversationContext(BeanManagerImpl manager, ServletContext ctx) {
        ObserverNotifier notifier = manager.getAccessibleLenientObserverNotifier();
        boolean noObservers = notifier.resolveObserverMethods(notifier.buildEventResolvable((Type)((Object)HttpServletRequest.class), InitializedLiteral.CONVERSATION)).isEmpty() && notifier.resolveObserverMethods(notifier.buildEventResolvable((Type)((Object)HttpServletRequest.class), DestroyedLiteral.CONVERSATION)).isEmpty();
        return this.getBooleanInitParameter(ctx, LAZY_CONVERSATION_CONTEXT_PARAM, noObservers);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.lifecycle.contextDestroyed(sce.getServletContext());
    }

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        this.lifecycle.sessionCreated(event.getSession());
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        this.lifecycle.sessionDestroyed(event.getSession());
    }

    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        if (!(event.getServletRequest() instanceof HttpServletRequest)) {
            throw ServletLogger.LOG.onlyHttpServletLifecycleDefined();
        }
        this.lifecycle.requestDestroyed((HttpServletRequest)event.getServletRequest());
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        if (!this.lifecycle.isConversationActivationSet()) {
            Object value = event.getServletContext().getAttribute(ConversationFilter.CONVERSATION_FILTER_REGISTERED);
            if (Boolean.TRUE.equals(value)) {
                this.lifecycle.setConversationActivationEnabled(false);
            } else {
                this.lifecycle.setConversationActivationEnabled(true);
            }
        }
        if (!(event.getServletRequest() instanceof HttpServletRequest)) {
            throw ServletLogger.LOG.onlyHttpServletLifecycleDefined();
        }
        this.lifecycle.requestInitialized((HttpServletRequest)event.getServletRequest(), event.getServletContext());
    }
}

