/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Collection;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.bootstrap.events.NotificationListener;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.util.DeploymentStructures;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractBeanDiscoveryEvent
extends AbstractDefinitionContainerEvent
implements NotificationListener {
    private final BeanDeploymentArchiveMapping bdaMapping;
    private final Deployment deployment;
    private final Collection<ContextHolder<? extends Context>> contexts;
    private Extension receiver;

    public AbstractBeanDiscoveryEvent(BeanManagerImpl beanManager, Type rawType, BeanDeploymentArchiveMapping bdaMapping, Deployment deployment, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, rawType, Reflections.EMPTY_TYPES);
        this.bdaMapping = bdaMapping;
        this.deployment = deployment;
        this.contexts = contexts;
    }

    protected BeanDeploymentArchiveMapping getBeanDeployments() {
        return this.bdaMapping;
    }

    protected Deployment getDeployment() {
        return this.deployment;
    }

    protected TypeStore getTypeStore() {
        return this.getDeployment().getServices().get(TypeStore.class);
    }

    protected BeanDeployment getOrCreateBeanDeployment(Class<?> clazz) {
        return DeploymentStructures.getOrCreateBeanDeployment(this.deployment, this.getBeanManager(), this.bdaMapping, this.contexts, clazz);
    }

    @Override
    public void preNotify(Extension extension) {
        this.receiver = extension;
    }

    @Override
    public void postNotify(Extension extension) {
        this.receiver = null;
    }

    protected Extension getSyntheticAnnotatedTypeSource() {
        return this.receiver;
    }

    protected void checkWithinObserverNotification() {
        if (this.receiver == null) {
            throw BootstrapLogger.LOG.containerLifecycleEventMethodInvokedOutsideObserver();
        }
    }
}

