/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public abstract class AbstractNamingScheme
implements NamingScheme {
    private final String delimiter;
    private final PrefixPredicate predicate;
    private final DeprefixerFunction deprefixerFunction;
    private final PrefixerFunction prefixerFunction;

    public AbstractNamingScheme(String delimiter) {
        this.delimiter = delimiter;
        this.predicate = new PrefixPredicate();
        this.deprefixerFunction = new DeprefixerFunction();
        this.prefixerFunction = new PrefixerFunction();
    }

    @Override
    public boolean accept(String id) {
        String prefix = this.getPrefix();
        return id.startsWith(prefix) && id.startsWith(this.delimiter, prefix.length());
    }

    @Override
    public BeanIdentifier deprefix(String id) {
        return new StringBeanIdentifier(id.substring(this.getPrefix().length() + this.delimiter.length()));
    }

    @Override
    public String prefix(BeanIdentifier id) {
        return this.getPrefix() + this.delimiter + id.asString();
    }

    @Override
    public Collection<String> filterIds(Collection<String> ids) {
        return new ArrayList<String>(Collections2.filter(ids, this.predicate));
    }

    @Override
    public Collection<BeanIdentifier> deprefix(Collection<String> ids) {
        return new ArrayList<BeanIdentifier>(Collections2.transform(ids, this.deprefixerFunction));
    }

    @Override
    public Collection<String> prefix(Collection<BeanIdentifier> ids) {
        return new ArrayList<String>(Collections2.transform(ids, this.prefixerFunction));
    }

    protected abstract String getPrefix();

    protected String getDelimiter() {
        return this.delimiter;
    }

    class PrefixerFunction
    implements Function<BeanIdentifier, String> {
        PrefixerFunction() {
        }

        @Override
        public String apply(BeanIdentifier from) {
            return AbstractNamingScheme.this.prefix(from);
        }
    }

    class DeprefixerFunction
    implements Function<String, BeanIdentifier> {
        DeprefixerFunction() {
        }

        @Override
        public BeanIdentifier apply(String from) {
            return AbstractNamingScheme.this.deprefix(from);
        }
    }

    class PrefixPredicate
    implements Predicate<String> {
        PrefixPredicate() {
        }

        @Override
        public boolean apply(String input) {
            return AbstractNamingScheme.this.accept(input);
        }
    }
}

