/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.inject;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public abstract class AbstractInjector {
    private final WeldManager manager;
    private final LoadingCache<Class<?>, InjectionTarget<?>> cache;

    protected AbstractInjector(final WeldManager manager) {
        Preconditions.checkArgumentNotNull(manager, "manager");
        this.manager = manager;
        this.cache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<Class<?>, InjectionTarget<?>>(){

            @Override
            public InjectionTarget<?> load(Class<?> key) throws Exception {
                AnnotatedType<?> type = manager.createAnnotatedType(key);
                return manager.createInjectionTargetBuilder(type).setResourceInjectionEnabled(false).setTargetClassLifecycleCallbacksEnabled(false).build();
            }
        });
    }

    protected void inject(Object instance) {
        InjectionTarget it = (InjectionTarget)LoadingCacheUtils.getCastCacheValue(this.cache, instance.getClass());
        WeldCreationalContext cc = this.manager.createCreationalContext(null);
        it.inject(instance, cc);
    }

    public void destroy(Object instance) {
        if (instance != null) {
            InjectionTarget it = (InjectionTarget)LoadingCacheUtils.getCastCacheValue(this.cache, instance.getClass());
            it.dispose(instance);
        }
    }
}

