/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jboss.weld.environment.servlet.EnhancedListener;
import org.jboss.weld.environment.servlet.WeldServletLifecycle;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;

public class Listener
extends ForwardingServletListener {
    public static final String LISTENER_USED_ATTRIBUTE_NAME = EnhancedListener.class.getPackage().getName() + ".listenerUsed";
    private volatile WeldServletLifecycle lifecycle;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        this.lifecycle = (WeldServletLifecycle)context.getAttribute(WeldServletLifecycle.INSTANCE_ATTRIBUTE_NAME);
        context.setAttribute(LISTENER_USED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
        if (this.lifecycle != null) {
            WeldServletLogger.LOG.enhancedListenerUsedForNotifications();
            return;
        }
        WeldServletLogger.LOG.initializeWeldUsingServletContextListener();
        this.lifecycle = new WeldServletLifecycle();
        this.lifecycle.initialize(context);
        super.contextInitialized(sce);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        super.contextDestroyed(sce);
        if (this.lifecycle == null) {
            WeldServletLogger.LOG.noServletLifecycleToDestroy();
            return;
        }
        this.lifecycle.destroy(sce.getServletContext());
    }

    @Override
    protected ServletListener delegate() {
        return this.lifecycle.getWeldListener();
    }
}

