/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.interceptor.InvocationContext;

public class SimpleInvocationContext
implements InvocationContext {
    private final Map<String, Object> contextData;
    private final Method method;
    private final Method proceed;
    private Object[] parameters;
    private final Object target;
    private final Object timer;
    private final Constructor<?> constructor;
    private static final Map<Class<?>, Set<Class<?>>> WIDENING_TABLE;

    public SimpleInvocationContext(Object target, Method targetMethod, Method proceed, Object[] parameters) {
        this(target, targetMethod, proceed, null, parameters, null, new HashMap<String, Object>());
    }

    public SimpleInvocationContext(Constructor<?> constructor, Object[] parameters, Map<String, Object> contextData) {
        this(null, null, null, constructor, parameters, null, contextData);
    }

    private SimpleInvocationContext(Object target, Method method, Method proceed, Constructor<?> constructor, Object[] parameters, Object timer, Map<String, Object> contextData) {
        this.target = target;
        this.method = method;
        this.proceed = proceed;
        this.constructor = constructor;
        this.parameters = parameters;
        this.timer = timer;
        this.contextData = contextData;
    }

    @Override
    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public Object[] getParameters() {
        if (this.method != null || this.constructor != null) {
            return this.parameters;
        }
        throw new IllegalStateException("Illegal invocation to getParameters() during lifecycle invocation");
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    private static boolean isWideningPrimitive(Class<?> argumentClass, Class<?> targetClass) {
        return WIDENING_TABLE.containsKey(argumentClass) && WIDENING_TABLE.get(argumentClass).contains(targetClass);
    }

    @Override
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public void setParameters(Object[] params) {
        if (this.method != null || this.constructor != null) {
            int newParametersCount = params == null ? 0 : params.length;
            Class<?>[] parameterTypes = null;
            parameterTypes = this.method != null ? this.method.getParameterTypes() : this.constructor.getParameterTypes();
            if (parameterTypes.length != newParametersCount) {
                throw new IllegalArgumentException("Wrong number of parameters: method has " + parameterTypes.length + ", attempting to set " + newParametersCount + (params != null ? "" : " (argument was null)"));
            }
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Class<?> methodParameterClass = parameterTypes[i];
                    if (params[i] != null) {
                        Class<?> newArgumentClass = params[i].getClass();
                        if (newArgumentClass.equals(methodParameterClass)) break;
                        if (newArgumentClass.isPrimitive()) {
                            if (methodParameterClass.isPrimitive()) {
                                if (SimpleInvocationContext.isWideningPrimitive(newArgumentClass, methodParameterClass)) continue;
                                this.throwIAE(i, methodParameterClass, newArgumentClass);
                                continue;
                            }
                            Class<?> boxedArgumentClass = Primitives.wrap(newArgumentClass);
                            if (methodParameterClass.isAssignableFrom(boxedArgumentClass)) continue;
                            this.throwIAE(i, methodParameterClass, newArgumentClass);
                            continue;
                        }
                        if (methodParameterClass.isPrimitive()) {
                            Class<?> unboxedClass = Primitives.unwrap(newArgumentClass);
                            if (unboxedClass.equals(methodParameterClass) || SimpleInvocationContext.isWideningPrimitive(unboxedClass, methodParameterClass)) continue;
                            this.throwIAE(i, methodParameterClass, newArgumentClass);
                            continue;
                        }
                        if (methodParameterClass.isAssignableFrom(newArgumentClass)) continue;
                        this.throwIAE(i, methodParameterClass, newArgumentClass);
                        continue;
                    }
                    if (!parameterTypes[i].isPrimitive()) continue;
                    throw new IllegalArgumentException("Trying to set a null value on a " + parameterTypes[i].getName());
                }
                this.parameters = params;
            }
        } else {
            throw new IllegalStateException("Illegal invocation to setParameters() during lifecycle invocation");
        }
    }

    private void throwIAE(int i, Class<?> methodParameterClass, Class<? extends Object> newArgumentClass) {
        throw new IllegalArgumentException("Incompatible parameter type on position: " + i + " :" + newArgumentClass + " (expected type was " + methodParameterClass.getName() + ")");
    }

    @Override
    public Object getTimer() {
        return this.timer;
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public Object proceed() throws Exception {
        if (this.proceed != null) {
            return this.proceed.invoke(this.target, this.parameters);
        }
        return null;
    }

    static {
        HashMap<Class<Serializable>, Set<Class<Double>>> wideningTable = new HashMap<Class<Serializable>, Set<Class<Double>>>();
        wideningTable.put(Byte.TYPE, ImmutableSet.of(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        wideningTable.put(Short.TYPE, ImmutableSet.of(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        wideningTable.put(Character.TYPE, ImmutableSet.of(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        wideningTable.put(Integer.TYPE, ImmutableSet.of(Long.TYPE, Float.TYPE, Double.TYPE));
        wideningTable.put(Long.TYPE, ImmutableSet.of(Float.TYPE, Double.TYPE));
        wideningTable.put(Float.TYPE, Collections.singleton(Double.TYPE));
        WIDENING_TABLE = Collections.unmodifiableMap(wideningTable);
    }
}

