/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.services;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.helpers.AbstractResourceServices;

public abstract class ServletResourceInjectionServices
extends AbstractResourceServices
implements ResourceInjectionServices {
    private static final String RESOURCE_LOOKUP_PREFIX = "java:comp/env";
    private Context context;

    public ServletResourceInjectionServices() {
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            throw WeldServletLogger.LOG.errorCreatingJNDIContext(e);
        }
    }

    @Override
    protected Context getContext() {
        return this.context;
    }

    @Override
    public Object resolveResource(InjectionPoint injectionPoint) {
        if (this.getResourceAnnotation(injectionPoint) == null) {
            throw new IllegalArgumentException("No @Resource annotation found on injection point " + injectionPoint);
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + injectionPoint);
        }
        String name = this.getResourceName(injectionPoint);
        try {
            return this.getContext().lookup(name);
        }
        catch (NamingException e) {
            return this.handleNamingException(e, name);
        }
    }

    @Override
    protected String getResourceName(InjectionPoint injectionPoint) {
        String propertyName;
        Resource resource = this.getResourceAnnotation(injectionPoint);
        String mappedName = resource.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name = resource.name();
        if (!name.equals("")) {
            return "java:comp/env/" + name;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = ServletResourceInjectionServices.getPropertyName((Method)injectionPoint.getMember());
            if (propertyName == null) {
                throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (unable to determine property name) " + injectionPoint);
            }
        } else {
            throw new AssertionError((Object)("Unable to inject into " + injectionPoint));
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    protected Resource getResourceAnnotation(InjectionPoint injectionPoint) {
        AnnotatedCallable annotated = injectionPoint.getAnnotated();
        if (annotated instanceof AnnotatedParameter) {
            annotated = ((AnnotatedParameter)((Object)annotated)).getDeclaringCallable();
        }
        return annotated.getAnnotation(Resource.class);
    }

    private Object handleNamingException(NamingException e, String name) {
        throw new RuntimeException("Error looking up " + name + " in JNDI", e);
    }
}

