/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotated;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedCallable;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_BAD_FIELD", "SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class BackedAnnotatedParameter<X>
extends BackedAnnotated
implements AnnotatedParameter<X>,
Serializable {
    private final int position;
    private final BackedAnnotatedCallable<X, ?> declaringCallable;

    public static <X> AnnotatedParameter<X> of(Type baseType, Annotation[] annotations, int position, BackedAnnotatedCallable<X, ?> declaringCallable, SharedObjectCache sharedObjectCache) {
        return new BackedAnnotatedParameter<X>(baseType, annotations, position, declaringCallable, sharedObjectCache);
    }

    public BackedAnnotatedParameter(Type baseType, Annotation[] annotations, int position, BackedAnnotatedCallable<X, ?> declaringCallable, SharedObjectCache sharedObjectCache) {
        super(baseType, sharedObjectCache);
        this.position = position;
        this.declaringCallable = declaringCallable;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public BackedAnnotatedCallable<X, ?> getDeclaringCallable() {
        return this.declaringCallable;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)((Annotation)Reflections.cast(annotation));
        }
        return null;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.getReflectionCache().getParameterAnnotationSet(this);
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return null;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringCallable == null ? 0 : this.declaringCallable.hashCode());
        result = 31 * result + this.position;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedParameter other = (BackedAnnotatedParameter)obj;
        if (this.declaringCallable == null ? other.declaringCallable != null : !this.declaringCallable.equals(other.declaringCallable)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return Formats.formatAnnotatedParameter(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.serializationProxyRequired();
    }

    @Override
    protected ReflectionCache getReflectionCache() {
        return ((BackedAnnotatedType)((BackedAnnotatedMember)((Object)this.getDeclaringCallable())).getDeclaringType()).getReflectionCache();
    }

    private static class SerializationProxy<X>
    implements Serializable {
        private static final long serialVersionUID = 8784172191880064479L;
        private final AnnotatedCallable<X> callable;
        private final int position;

        public SerializationProxy(BackedAnnotatedParameter<X> parameter) {
            this.callable = parameter.getDeclaringCallable();
            this.position = parameter.getPosition();
        }

        private Object readResolve() throws ObjectStreamException {
            return this.callable.getParameters().get(this.position);
        }
    }
}

