/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.DeferredEventNotification;
import org.jboss.weld.event.EventPacket;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.Status;
import org.jboss.weld.event.TransactionNotificationSynchronization;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.transaction.spi.TransactionServices;

public class TransactionalObserverNotifier
extends ObserverNotifier {
    private final TransactionServices transactionServices;
    private final String contextId;

    protected TransactionalObserverNotifier(String contextId, TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        super(resolver, services, strict);
        this.contextId = contextId;
        this.transactionServices = services.get(TransactionServices.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void notifyObservers(EventPacket<T> eventPacket, List<ObserverMethod<? super T>> observers) {
        if (this.transactionServices == null || !this.transactionServices.isTransactionActive()) {
            super.notifyObservers(eventPacket, observers);
        } else {
            ArrayList notifications = new ArrayList();
            this.currentEventMetadata.push(eventPacket);
            try {
                for (ObserverMethod<T> observer : observers) {
                    if (TransactionPhase.IN_PROGRESS.equals((Object)observer.getTransactionPhase())) {
                        super.notifyObserver(eventPacket, observer);
                        continue;
                    }
                    this.deferNotification(eventPacket, observer, notifications);
                }
            }
            finally {
                this.currentEventMetadata.pop();
            }
            if (!notifications.isEmpty()) {
                this.transactionServices.registerSynchronization(new TransactionNotificationSynchronization(notifications));
            }
        }
    }

    private <T> void deferNotification(EventPacket<T> packet, ObserverMethod<? super T> observer, List<DeferredEventNotification<?>> notifications) {
        TransactionPhase transactionPhase = observer.getTransactionPhase();
        boolean before = transactionPhase.equals((Object)TransactionPhase.BEFORE_COMPLETION);
        Status status = Status.valueOf(transactionPhase);
        notifications.add(new DeferredEventNotification<T>(this.contextId, packet, observer, this.currentEventMetadata, status, before));
    }
}

