/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit;

import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.function.Function;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;

public class MockJpaInjectionServices
implements JpaInjectionServices {
    private final Function<InjectionPoint, Object> persistenceUnitFactory;
    private final Function<InjectionPoint, Object> persistenceContextFactory;

    public MockJpaInjectionServices(Function<InjectionPoint, Object> persistenceUnitFactory, Function<InjectionPoint, Object> persistenceContextFactory) {
        this.persistenceUnitFactory = persistenceUnitFactory;
        this.persistenceContextFactory = persistenceContextFactory;
    }

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(final InjectionPoint injectionPoint) {
        return new ResourceReferenceFactory<EntityManager>(){

            public ResourceReference<EntityManager> createResource() {
                if (MockJpaInjectionServices.this.persistenceContextFactory == null) {
                    throw new IllegalStateException("Persistent context factory not set, cannot resolve injection point: " + String.valueOf(injectionPoint));
                }
                Object context = MockJpaInjectionServices.this.persistenceContextFactory.apply(injectionPoint);
                if (context == null || context instanceof EntityManager) {
                    return new SimpleResourceReference((Object)((EntityManager)context));
                }
                throw new IllegalStateException("Not an EntityManager instance: " + String.valueOf(context));
            }
        };
    }

    public ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(final InjectionPoint injectionPoint) {
        return new ResourceReferenceFactory<EntityManagerFactory>(){

            public ResourceReference<EntityManagerFactory> createResource() {
                if (MockJpaInjectionServices.this.persistenceUnitFactory == null) {
                    throw new IllegalStateException("Persistent unit factory not set, cannot resolve injection point: " + String.valueOf(injectionPoint));
                }
                Object unit = MockJpaInjectionServices.this.persistenceUnitFactory.apply(injectionPoint);
                if (unit == null || unit instanceof EntityManagerFactory) {
                    return new SimpleResourceReference((Object)((EntityManagerFactory)unit));
                }
                throw new IllegalStateException("Not an EntityManagerFactory instance: " + String.valueOf(unit));
            }
        };
    }

    public void cleanup() {
    }
}

