/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit4;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

class ContextImpl
implements Context {
    private final Class<? extends Annotation> scope;
    private final ThreadLocal<Map<Contextual<?>, ContextualInstance<?>>> currentContext = new ThreadLocal();

    public ContextImpl(Class<? extends Annotation> scope) {
        this.scope = scope;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        ContextualInstance<Object> instance = ctx.get(contextual);
        if (instance == null && creationalContext != null) {
            instance = new ContextualInstance<Object>(contextual.create(creationalContext), creationalContext, contextual);
            ctx.put(contextual, instance);
        }
        return instance != null ? (T)instance.get() : null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return this.currentContext.get() != null;
    }

    public void destroy(Contextual<?> contextual) {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return;
        }
        ctx.remove(contextual);
    }

    public void activate() {
        this.currentContext.set(new HashMap());
    }

    public void deactivate() {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return;
        }
        for (ContextualInstance<?> instance : ctx.values()) {
            try {
                instance.destroy();
            }
            catch (Exception exception) {}
        }
        ctx.clear();
        this.currentContext.remove();
    }

    static final class ContextualInstance<T> {
        private final T value;
        private final CreationalContext<T> creationalContext;
        private final Contextual<T> contextual;

        ContextualInstance(T instance, CreationalContext<T> creationalContext, Contextual<T> contextual) {
            this.value = instance;
            this.creationalContext = creationalContext;
            this.contextual = contextual;
        }

        T get() {
            return this.value;
        }

        Contextual<T> getContextual() {
            return this.contextual;
        }

        void destroy() {
            this.contextual.destroy(this.value, this.creationalContext);
        }
    }
}

